/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.blocks;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.herbalbrews.core.blocks.entity.JugBlockEntity;
import net.satisfy.herbalbrews.core.items.DrinkBlockItem;
import net.satisfy.herbalbrews.platform.PlatformHelper;
import org.jetbrains.annotations.NotNull;

public class JugBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final IntegerProperty FILL_STAGE = IntegerProperty.m_61631_((String)"fill_stage", (int)0, (int)3);
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.1875, (double)0.8125, (double)0.875, (double)0.8125);

    public JugBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, FILL_STAGE});
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(0));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new JugBlockEntity(pos, state);
    }

    @NotNull
    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof JugBlockEntity)) {
            return InteractionResult.PASS;
        }
        JugBlockEntity jug = (JugBlockEntity)blockEntity;
        if (heldItem.m_41720_() instanceof DrinkBlockItem) {
            if (jug.getDrinks().size() < 3) {
                ItemStack drinkToAdd = heldItem.m_41777_();
                drinkToAdd.m_41764_(1);
                jug.addDrink(drinkToAdd);
                heldItem.m_41774_(1);
                int fillStage = jug.getDrinks().size();
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(fillStage)), 3);
                world.m_5594_(null, pos, SoundEvents.f_11770_, SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        if (!jug.getDrinks().isEmpty()) {
            int duration = PlatformHelper.getJugEffectDuration();
            jug.applyEffects((LivingEntity)player, duration);
            jug.clearDrinks();
            world.m_7731_(pos, (BlockState)state.m_61124_((Property)FILL_STAGE, (Comparable)Integer.valueOf(0)), 3);
            world.m_5594_(null, pos, SoundEvents.f_11970_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    public void m_5871_(ItemStack itemStack, BlockGetter world, List<Component> tooltip, TooltipFlag tooltipContext) {
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.description.title").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)5025616)).m_131136_(Boolean.valueOf(true))));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.description.jug_1").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)5025616)).m_131155_(Boolean.valueOf(false))));
            tooltip.add((Component)Component.m_237119_());
            tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.description.jug_2").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)5025616)).m_131155_(Boolean.valueOf(false))));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.herbalbrews.canbeplaced").m_130938_(style -> style.m_131148_(TextColor.m_131266_((int)13467442)).m_131155_(Boolean.valueOf(true))));
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof JugBlockEntity) {
                JugBlockEntity jug = (JugBlockEntity)blockEntity;
                for (ItemStack drink : jug.getDrinks()) {
                    Containers.m_18992_((Level)world, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)drink);
                }
            }
            super.m_6810_(state, world, pos, newState, isMoving);
        }
    }
}

