/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.gallery.client.gui.screens.inventory;

import com.mojang.blaze3d.platform.InputConstants;
import com.teamabnormals.gallery.common.inventory.PaintingSelectorMenu;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;

@OnlyIn(value=Dist.CLIENT)
public class PaintingSelectorScreen
extends AbstractContainerScreen<PaintingSelectorMenu> {
    private static final ResourceLocation BG_LOCATION = new ResourceLocation("gallery", "textures/gui/painting_selector.png");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private EditBox searchBox;
    private boolean ignoreTextInput;

    public PaintingSelectorScreen(PaintingSelectorMenu p_99310_, Inventory p_99311_, Component p_99312_) {
        super((AbstractContainerMenu)p_99310_, p_99311_, p_99312_);
        --this.f_97729_;
        this.f_97727_ = 126;
    }

    public void m_88315_(GuiGraphics p_281735_, int p_282517_, int p_282840_, float p_282389_) {
        super.m_88315_(p_281735_, p_282517_, p_282840_, p_282389_);
        this.m_280072_(p_281735_, p_282517_, p_282840_);
    }

    protected void m_280003_(GuiGraphics p_281635_, int p_282681_, int p_283686_) {
        p_281635_.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_, this.f_97729_, 0x404040, false);
    }

    public void m_7856_() {
        super.m_7856_();
        this.searchBox = new EditBox(this.f_96547_, this.f_97735_ + 89, this.f_97736_ + 10, 65, 9, (Component)Component.m_237115_((String)"itemGroup.search"));
        this.searchBox.m_94199_(50);
        this.searchBox.m_94182_(false);
        this.searchBox.m_94194_(true);
        this.searchBox.m_94202_(0xFFFFFF);
        this.searchBox.m_94190_(true);
        this.searchBox.m_93692_(false);
        this.m_7787_((GuiEventListener)this.searchBox);
        this.refreshSearchResults();
    }

    public void m_6574_(Minecraft p_98595_, int p_98596_, int p_98597_) {
        float scrollOffset = this.scrollOffs;
        int startIndex = this.startIndex;
        String s = this.searchBox.m_94155_();
        Holder<PaintingVariant> selected = ((PaintingSelectorMenu)this.f_97732_).getSelectedPainting();
        this.m_6575_(p_98595_, p_98596_, p_98597_);
        this.searchBox.m_94144_(s);
        if (!this.searchBox.m_94155_().isEmpty()) {
            this.refreshSearchResults();
        }
        ((PaintingSelectorMenu)this.f_97732_).setSelectedPainting(selected);
        this.scrollOffs = scrollOffset;
        this.startIndex = startIndex;
    }

    public boolean m_5534_(char p_98521_, int p_98522_) {
        if (this.ignoreTextInput) {
            return false;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_5534_(p_98521_, p_98522_)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return false;
    }

    public boolean m_7933_(int p_98547_, int p_98548_, int p_98549_) {
        this.ignoreTextInput = false;
        boolean flag1 = InputConstants.m_84827_((int)p_98547_, (int)p_98548_).m_84876_().isPresent();
        if (flag1 && this.m_97805_(p_98547_, p_98548_)) {
            this.ignoreTextInput = true;
            return true;
        }
        String s = this.searchBox.m_94155_();
        if (this.searchBox.m_7933_(p_98547_, p_98548_, p_98549_)) {
            if (!Objects.equals(s, this.searchBox.m_94155_())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.m_93696_() && this.searchBox.m_94213_() && p_98547_ != 256 ? true : super.m_7933_(p_98547_, p_98548_, p_98549_);
    }

    public boolean m_7920_(int p_98612_, int p_98613_, int p_98614_) {
        this.ignoreTextInput = false;
        return super.m_7920_(p_98612_, p_98613_, p_98614_);
    }

    private void refreshSearchResults() {
        ((PaintingSelectorMenu)this.f_97732_).setupPaintingLists();
        String s = this.searchBox.m_94155_().toLowerCase(Locale.ROOT);
        if (!s.isEmpty()) {
            ArrayList searched = Lists.newArrayList();
            for (Holder<PaintingVariant> variant : ((PaintingSelectorMenu)this.f_97732_).getAllPaintings()) {
                variant.m_203543_().ifPresent(key -> {
                    String title = Component.m_237115_((String)key.m_135782_().m_269108_("painting", "title")).getString().toLowerCase(Locale.ROOT);
                    String author = Component.m_237115_((String)key.m_135782_().m_269108_("painting", "author")).getString().toLowerCase(Locale.ROOT);
                    String dimensions = Component.m_237110_((String)"painting.dimensions", (Object[])new Object[]{Mth.m_184652_((int)((PaintingVariant)variant.m_203334_()).m_218908_(), (int)16), Mth.m_184652_((int)((PaintingVariant)variant.m_203334_()).m_218909_(), (int)16)}).getString().toLowerCase(Locale.ROOT);
                    if (title.contains(s) || author.contains(s) || dimensions.contains(s)) {
                        searched.add(variant);
                    }
                });
            }
            ((PaintingSelectorMenu)this.f_97732_).paintings = searched;
        }
        this.scrollOffs = 0.0f;
        this.startIndex = 0;
    }

    public void m_181908_() {
        super.m_181908_();
        if (this.f_96541_ != null) {
            this.searchBox.m_94120_();
        }
    }

    protected void m_7286_(GuiGraphics gui, float p_282453_, int p_282940_, int p_282328_) {
        this.m_280273_(gui);
        int i = this.f_97735_;
        int j = this.f_97736_;
        gui.m_280218_(BG_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
        int k = (int)(74.0f * this.scrollOffs);
        gui.m_280218_(BG_LOCATION, i + 155, j + 22 + k, 176 + (this.isScrollBarActive() ? 0 : 12), 0, 12, 15);
        int l = this.f_97735_ + 88;
        int i1 = this.f_97736_ + 21;
        int j1 = this.startIndex + 20;
        this.renderButtons(gui, p_282940_, p_282328_, l, i1, j1);
        this.renderRecipes(gui, l, i1, j1);
        if (((PaintingSelectorMenu)this.f_97732_).getSelectedPainting() != null) {
            PaintingVariant variant = (PaintingVariant)((PaintingSelectorMenu)this.f_97732_).getSelectedPainting().get();
            gui.m_280159_(i + 13, j + 19, 0, variant.m_218908_(), variant.m_218909_(), Minecraft.m_91087_().m_91305_().m_235033_(variant));
        }
        this.searchBox.m_88315_(gui, p_282940_, p_282328_, p_282453_);
    }

    protected void m_280072_(GuiGraphics gui, int p_283157_, int p_282258_) {
        super.m_280072_(gui, p_283157_, p_282258_);
        int i = this.f_97735_ + 88;
        int j = this.f_97736_ + 21;
        int k = this.startIndex + 20;
        List<Holder<PaintingVariant>> list = ((PaintingSelectorMenu)this.f_97732_).getPaintings();
        for (int l = this.startIndex; l < k && l < ((PaintingSelectorMenu)this.f_97732_).getNumPaintings(); ++l) {
            int i1 = l - this.startIndex;
            int j1 = i + i1 % 4 * 16;
            int k1 = j + i1 / 4 * 18 + 2;
            if (p_283157_ < j1 || p_283157_ >= j1 + 16 || p_282258_ < k1 || p_282258_ >= k1 + 18) continue;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42487_);
            CompoundTag tag = stack.m_41698_("EntityTag");
            Painting.m_269220_((CompoundTag)tag, list.get(l));
            gui.m_280153_(this.f_96547_, stack, p_283157_, p_282258_);
        }
    }

    private void renderButtons(GuiGraphics gui, int p_282136_, int p_282147_, int p_281987_, int p_281276_, int p_282688_) {
        for (int i = this.startIndex; i < p_282688_ && i < ((PaintingSelectorMenu)this.f_97732_).getNumPaintings(); ++i) {
            int j = i - this.startIndex;
            int k = p_281987_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_281276_ + l * 18 + 2;
            int j1 = this.f_97727_;
            if (((PaintingSelectorMenu)this.f_97732_).getSelectedPainting() != null && i == ((PaintingSelectorMenu)this.f_97732_).getPaintings().indexOf(((PaintingSelectorMenu)this.f_97732_).getSelectedPainting())) {
                j1 += 18;
            } else if (p_282136_ >= k && p_282147_ >= i1 && p_282136_ < k + 16 && p_282147_ < i1 + 18) {
                j1 += 36;
            }
            gui.m_280218_(BG_LOCATION, k, i1 - 1, 0, j1, 16, 18);
        }
    }

    private void renderRecipes(GuiGraphics gui, int p_282658_, int p_282563_, int slots) {
        List<Holder<PaintingVariant>> list = ((PaintingSelectorMenu)this.f_97732_).getPaintings();
        for (int i = this.startIndex; i < slots && i < ((PaintingSelectorMenu)this.f_97732_).getNumPaintings(); ++i) {
            int j = i - this.startIndex;
            int k = p_282658_ + j % 4 * 16;
            int l = j / 4;
            int i1 = p_282563_ + l * 18 + 2;
            ItemStack stack = new ItemStack((ItemLike)Items.f_42487_);
            CompoundTag tag = stack.m_41698_("EntityTag");
            Painting.m_269220_((CompoundTag)tag, list.get(i));
            gui.m_280480_(stack, k, i1);
        }
    }

    public boolean m_6375_(double p_99318_, double p_99319_, int p_99320_) {
        this.scrolling = false;
        int i = this.f_97735_ + 88;
        int j = this.f_97736_ + 21;
        int k = this.startIndex + 20;
        for (int l = this.startIndex; l < k; ++l) {
            int i1 = l - this.startIndex;
            double d0 = p_99318_ - (double)(i + i1 % 4 * 16);
            double d1 = p_99319_ - (double)(j + i1 / 4 * 18);
            if (!(d0 >= 0.0) || !(d1 >= 0.0) || !(d0 < 16.0) || !(d1 < 18.0) || !((PaintingSelectorMenu)this.f_97732_).m_6366_((Player)this.f_96541_.f_91074_, l)) continue;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_12495_, (float)1.0f));
            this.f_96541_.f_91072_.m_105208_(((PaintingSelectorMenu)this.f_97732_).f_38840_, l);
            this.searchBox.m_93692_(false);
            return true;
        }
        i = this.f_97735_ + 155;
        j = this.f_97736_ + 9;
        if (p_99318_ >= (double)i && p_99318_ < (double)(i + 20) && p_99319_ >= (double)j && p_99319_ < (double)(j + 112)) {
            this.scrolling = true;
            this.searchBox.m_93692_(false);
        }
        return super.m_6375_(p_99318_, p_99319_, p_99320_);
    }

    public boolean m_7979_(double p_99322_, double p_99323_, int p_99324_, double p_99325_, double p_99326_) {
        if (this.scrolling && this.isScrollBarActive()) {
            int i = this.f_97736_ + 14;
            int j = i + 92;
            this.scrollOffs = ((float)p_99323_ - (float)i - 7.5f) / ((float)(j - i) - 15.0f);
            this.scrollOffs = Mth.m_14036_((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * 4;
            return true;
        }
        return super.m_7979_(p_99322_, p_99323_, p_99324_, p_99325_, p_99326_);
    }

    public boolean m_6050_(double p_99314_, double p_99315_, double p_99316_) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)p_99316_ / (float)i;
            this.scrollOffs = Mth.m_14036_((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * 4;
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return ((PaintingSelectorMenu)this.f_97732_).getNumPaintings() > 20;
    }

    protected int getOffscreenRows() {
        return (((PaintingSelectorMenu)this.f_97732_).getNumPaintings() + 4 - 1) / 4 - 5;
    }
}

