/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.common.worldgen.modifier.forge;

import com.blackgear.platform.Platform;
import com.blackgear.platform.common.worldgen.modifier.BiomeContext;
import com.blackgear.platform.common.worldgen.modifier.BiomeManager;
import com.blackgear.platform.common.worldgen.modifier.BiomeWriter;
import com.blackgear.platform.core.util.WorldGenSerialization;
import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.Nullable;

public class BiomeManagerImpl {
    @Nullable
    private static Codec<PlatformBiomeModifier> codec = null;

    public static void bootstrap() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> {
            event.register(ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, entry -> {
                codec = Codec.unit((Object)PlatformBiomeModifier.INSTANCE);
                entry.register(Platform.resource("biome_modifier_codec"), (Object)codec);
            });
            event.register(ForgeRegistries.Keys.BIOME_MODIFIERS, entry -> entry.register(Platform.resource("biome_modifier"), (Object)PlatformBiomeModifier.INSTANCE));
        });
    }

    static class PlatformBiomeModifier
    implements BiomeModifier {
        private static final PlatformBiomeModifier INSTANCE = new PlatformBiomeModifier();

        PlatformBiomeModifier() {
        }

        public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            if (phase == BiomeModifier.Phase.ADD) {
                BiomeManager.INSTANCE.register(new ForgeBiomeWriter(biome, builder));
            }
        }

        public Codec<? extends BiomeModifier> codec() {
            return codec != null ? codec : Codec.unit((Object)INSTANCE);
        }
    }

    static class ForgeBiomeWriter
    extends BiomeWriter {
        private final Holder<Biome> biome;
        private final ModifiableBiomeInfo.BiomeInfo.Builder builder;

        ForgeBiomeWriter(Holder<Biome> biome, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
            this.biome = biome;
            this.builder = builder;
        }

        @Override
        public ResourceLocation name() {
            return ((ResourceKey)this.biome.m_203543_().orElseThrow()).m_135782_();
        }

        @Override
        public BiomeContext context() {
            return new BiomeContext(){

                @Override
                public ResourceKey<Biome> resource() {
                    return (ResourceKey)biome.m_203543_().orElseThrow();
                }

                @Override
                public Biome biome() {
                    return (Biome)biome.m_203334_();
                }

                @Override
                public boolean is(TagKey<Biome> tag) {
                    return biome.m_203656_(tag);
                }

                @Override
                public boolean is(ResourceKey<Biome> biome) {
                    return this.resource() == biome;
                }

                @Override
                public boolean is(Predicate<BiomeContext> context) {
                    return context.test(this);
                }

                @Override
                public boolean hasFeature(ResourceKey<PlacedFeature> feature) {
                    Optional<Holder.Reference<PlacedFeature>> optional = ForgeBiomeWriter.getRegistryEntry(Registries.f_256988_, feature);
                    if (optional.isPresent()) {
                        Holder.Reference<PlacedFeature> placedFeature = optional.get();
                        return Arrays.stream(GenerationStep.Decoration.values()).anyMatch(decoration -> builder.getGenerationSettings().getFeatures(decoration).stream().anyMatch(match -> WorldGenSerialization.serializeAndCompareFeature((PlacedFeature)match.get(), (PlacedFeature)placedFeature.get())));
                    }
                    return false;
                }
            };
        }

        private static <T> Optional<Holder.Reference<T>> getRegistryEntry(ResourceKey<? extends Registry<T>> registryKey, ResourceKey<T> entryKey) {
            MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
            if (server != null) {
                return server.m_206579_().m_6632_(registryKey).flatMap(registry -> registry.m_203636_(entryKey));
            }
            return Optional.empty();
        }

        @Override
        public void addFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            ForgeBiomeWriter.getRegistryEntry(Registries.f_256988_, feature).ifPresent(placedFeature -> this.builder.getGenerationSettings().m_255419_(decoration, (Holder)placedFeature));
        }

        @Override
        public void removeFeature(GenerationStep.Decoration decoration, ResourceKey<PlacedFeature> feature) {
            ForgeBiomeWriter.getRegistryEntry(Registries.f_256988_, feature).ifPresent(placedFeature -> this.builder.getGenerationSettings().getFeatures(decoration).removeIf(match -> WorldGenSerialization.serializeAndCompareFeature((PlacedFeature)match.get(), (PlacedFeature)placedFeature.get())));
        }

        @Override
        public void addSpawn(MobCategory category, MobSpawnSettings.SpawnerData data) {
            this.builder.getMobSpawnSettings().m_48376_(category, data);
        }

        @Override
        public void removeSpawn(EntityType<?> entity) {
            this.builder.getMobSpawnSettings().getSpawner(entity.m_20674_()).removeIf(spawner -> spawner.f_48404_ == entity);
        }

        @Override
        public void addCarver(GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> carver) {
            ForgeBiomeWriter.getRegistryEntry(Registries.f_257003_, carver).ifPresent(configuredCarver -> this.builder.getGenerationSettings().m_254863_(carving, (Holder)configuredCarver));
        }

        @Override
        public void removeCarver(GenerationStep.Carving carving, ResourceKey<ConfiguredWorldCarver<?>> carver) {
            ForgeBiomeWriter.getRegistryEntry(Registries.f_257003_, carver).ifPresent(configuredCarver -> this.builder.getGenerationSettings().getCarvers(carving).removeIf(match -> WorldGenSerialization.serializeAndCompareCarver((ConfiguredWorldCarver)match.get(), (ConfiguredWorldCarver)configuredCarver.get())));
        }
    }
}

