/*
 * Decompiled with CFR 0.152.
 */
package trofers.trophy.builder;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import trofers.trophy.builder.TrophyBuilder;
import trofers.trophy.components.EntityInfo;

public class EntityTrophyBuilder<T extends EntityTrophyBuilder<T>>
extends TrophyBuilder<T> {
    private final ResourceLocation entityId;
    private final CompoundTag entityTag = new CompoundTag();

    protected EntityTrophyBuilder(ResourceLocation entityId) {
        this.entityId = entityId;
    }

    public ResourceLocation getEntityId() {
        return this.entityId;
    }

    @Override
    protected ItemStack getDisplayItem() {
        return ItemStack.f_41583_;
    }

    @Override
    protected void displayItemToJson(JsonObject result) {
    }

    @Override
    protected Optional<EntityInfo> getEntityInfo() {
        return Optional.of(new EntityInfo((EntityType)BuiltInRegistries.f_256780_.m_7745_(this.entityId), this.entityTag, false));
    }

    @Override
    protected void entityInfoToJson(JsonObject result) {
        JsonObject entity = new JsonObject();
        entity.addProperty("type", this.entityId.toString());
        if (!this.entityTag.m_128456_()) {
            entity.addProperty("nbt", this.entityTag.toString());
        }
        result.add("entity", (JsonElement)entity);
    }

    public T tag(Consumer<CompoundTag> tagConsumer) {
        tagConsumer.accept(this.entityTag);
        return (T)this;
    }

    public T tag(String name, Consumer<CompoundTag> tagConsumer) {
        if (!this.entityTag.m_128441_(name)) {
            this.entityTag.m_128365_(name, (Tag)new CompoundTag());
        }
        tagConsumer.accept(this.entityTag.m_128469_(name));
        return (T)this;
    }

    public T putTag(String name, CompoundTag nbt) {
        this.entityTag.m_128365_(name, (Tag)nbt);
        return (T)this;
    }

    public T putByte(String name, byte b) {
        this.entityTag.m_128344_(name, b);
        return (T)this;
    }

    public T putInt(String name, int i) {
        this.entityTag.m_128405_(name, i);
        return (T)this;
    }

    public T putFloat(String name, float f) {
        this.entityTag.m_128350_(name, f);
        return (T)this;
    }

    public T putBoolean(String name, boolean b) {
        this.entityTag.m_128379_(name, b);
        return (T)this;
    }

    public T putString(String name, String s) {
        this.entityTag.m_128359_(name, s);
        return (T)this;
    }

    public T putUUID(String name, UUID uuid) {
        this.entityTag.m_128362_(name, uuid);
        return (T)this;
    }

    public T putCustomName(String customName) {
        return this.putString("CustomName", Component.Serializer.m_130703_((Component)Component.m_237113_((String)customName)));
    }

    public T putItem(String tag, ItemStack stack) {
        return this.putTag(tag, stack.m_41739_(new CompoundTag()));
    }

    public T putItem(String tag, Item item) {
        return this.putItem(tag, new ItemStack((ItemLike)item));
    }

    public T putEquipment(EquipmentSlot slot, CompoundTag item) {
        ListTag slots;
        String tagName;
        String string = tagName = slot.m_20743_() == EquipmentSlot.Type.HAND ? "HandItems" : "ArmorItems";
        if (!this.entityTag.m_128425_(tagName, 9)) {
            slots = new ListTag();
            int size = slot.m_20743_() == EquipmentSlot.Type.HAND ? 2 : 4;
            for (int i = 0; i < size; ++i) {
                slots.add((Object)new CompoundTag());
            }
            this.entityTag.m_128365_(tagName, (Tag)slots);
        }
        slots = this.entityTag.m_128437_(tagName, 10);
        slots.set(slot.m_20749_(), (Tag)item);
        return (T)this;
    }

    public T putEquipment(EquipmentSlot slot, ItemStack itemStack) {
        return this.putEquipment(slot, itemStack.m_41739_(new CompoundTag()));
    }

    public T putEquipment(EquipmentSlot slot, Item item) {
        return this.putEquipment(slot, new ItemStack((ItemLike)item));
    }

    public T putHandItem(Item item) {
        return this.putEquipment(EquipmentSlot.MAINHAND, item);
    }
}

