/*
 * Decompiled with CFR 0.152.
 */
package trofers.block.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import trofers.block.entity.TrophyBlockEntity;
import trofers.trophy.Trophy;
import trofers.trophy.components.Animation;
import trofers.trophy.components.EntityInfo;

public class TrophyBlockEntityRenderer
implements BlockEntityRenderer<TrophyBlockEntity> {
    public TrophyBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public boolean shouldRenderOffScreen(TrophyBlockEntity blockEntity) {
        return true;
    }

    public void render(TrophyBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.0, 0.5);
        Direction direction = ((Direction)blockEntity.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_)).m_122424_();
        poseStack.m_252781_(Axis.f_252436_.m_252977_(-direction.m_122435_()));
        Trophy trophy = blockEntity.getTrophy();
        if (trophy != null && Minecraft.m_91087_().f_91074_ != null) {
            float ticks = (float)Minecraft.m_91087_().f_91074_.f_19797_ + partialTicks + blockEntity.getAnimationOffset();
            TrophyBlockEntityRenderer.render(trophy, ticks, blockEntity.getTrophyHeight(), poseStack, multiBufferSource, light, overlay);
        }
        poseStack.m_85849_();
    }

    public static void render(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        TrophyBlockEntityRenderer.renderItem(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light, overlay);
        TrophyBlockEntityRenderer.renderEntity(trophy, ticks, trophyHeight, poseStack, multiBufferSource, light);
    }

    private static void renderItem(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light, int overlay) {
        poseStack.m_85836_();
        ItemRenderer renderer = Minecraft.m_91087_().m_91291_();
        BakedModel model = renderer.m_174264_(trophy.item(), (Level)Minecraft.m_91087_().f_91073_, null, 0);
        float yOffset = 0.25f;
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, yOffset, ticks);
        poseStack.m_85837_(0.0, 0.25, 0.0);
        if (!model.m_7539_()) {
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        }
        Minecraft.m_91087_().m_91291_().m_269128_(trophy.item(), ItemDisplayContext.FIXED, light, overlay, poseStack, multiBufferSource, (Level)Minecraft.m_91087_().f_91073_, 0);
        poseStack.m_85849_();
    }

    private static void renderEntity(Trophy trophy, float ticks, int trophyHeight, PoseStack poseStack, MultiBufferSource multiBufferSource, int light) {
        if (Minecraft.m_91087_().f_91073_ == null || trophy.entity().isEmpty()) {
            return;
        }
        EntityInfo entityInfo = trophy.entity().get();
        Entity entity = entityInfo.getOrCreateEntity((Level)Minecraft.m_91087_().f_91073_);
        if (entity == null) {
            return;
        }
        poseStack.m_85836_();
        float entityHeight = entity.m_20206_();
        TrophyBlockEntityRenderer.translateRotate(poseStack, trophy, trophyHeight, entityHeight / 2.0f, ticks);
        if (!entityInfo.isAnimated()) {
            ticks = 0.0f;
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        Minecraft.m_91087_().m_91290_().m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, ticks, poseStack, multiBufferSource, light);
        poseStack.m_85849_();
    }

    private static void translateRotate(PoseStack poseStack, Trophy trophy, int trophyHeight, float yRotationOffset, float ticks) {
        float animationProgress = 6.0f * ticks * trophy.animation().speed();
        poseStack.m_85837_(0.0, (double)((float)trophyHeight + trophy.display().yOffset()) / 16.0, 0.0);
        poseStack.m_252880_(0.0f, yRotationOffset *= trophy.display().scale(), 0.0f);
        if (trophy.animation().type() == Animation.Type.SPINNING) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animationProgress));
        } else if (trophy.animation().type() == Animation.Type.TUMBLING) {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(animationProgress));
            poseStack.m_252781_(Axis.f_252529_.m_252977_(animationProgress * 0.8f));
            poseStack.m_252781_(Axis.f_252403_.m_252977_(animationProgress * 0.6f));
        }
        poseStack.m_252880_(0.0f, -yRotationOffset, 0.0f);
        poseStack.m_85837_((double)trophy.display().xOffset() / 16.0, 0.0, 0.0);
        poseStack.m_85837_(0.0, 0.0, (double)trophy.display().zOffset() / 16.0);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(trophy.display().xRotation()));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(trophy.display().yRotation()));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(trophy.display().zRotation()));
        float scale = trophy.display().scale();
        poseStack.m_85841_(scale, scale, scale);
    }
}

