/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.network;

import com.pedrorok.hypertube.network.Packet;
import com.pedrorok.hypertube.network.packets.ActionPointReachPacket;
import com.pedrorok.hypertube.network.packets.EntityTravelDirDataPacket;
import com.pedrorok.hypertube.network.packets.FinishPathPacket;
import com.pedrorok.hypertube.network.packets.MovePathPacket;
import com.pedrorok.hypertube.network.packets.SpeedChangePacket;
import com.pedrorok.hypertube.network.packets.SyncEntityPosPacket;
import com.pedrorok.hypertube.network.packets.SyncPersistentDataPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class NetworkHandler {
    public static SimpleChannel INSTANCE;
    private static String PROTOCOL_VERSION;
    private static int id;

    public static void init() {
        PROTOCOL_VERSION = ModList.get().getModFileById("create_hypertube").versionString();
        INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("create_hypertube", "connections"), () -> PROTOCOL_VERSION, PROTOCOL_VERSION::equals, PROTOCOL_VERSION::equals);
        NetworkHandler.register(SyncPersistentDataPacket.class);
        NetworkHandler.register(FinishPathPacket.class);
        NetworkHandler.register(MovePathPacket.class);
        NetworkHandler.register(SyncEntityPosPacket.class);
        NetworkHandler.register(EntityTravelDirDataPacket.class);
        NetworkHandler.register(SpeedChangePacket.class);
        NetworkHandler.register(ActionPointReachPacket.class);
    }

    private static <T extends Packet<T>> void register(Class<T> clazz) {
        INSTANCE.registerMessage(id++, clazz, Packet::toBytes, friendlyByteBuf -> {
            try {
                return (Packet)clazz.getConstructor(FriendlyByteBuf.class).newInstance(friendlyByteBuf);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }, Packet::execute);
    }

    static {
        id = 0;
    }
}

