/*
 * Decompiled with CFR 0.152.
 */
package com.pedrorok.hypertube.config;

import com.pedrorok.hypertube.core.travel.TravelConstants;
import com.pedrorok.hypertube.utils.TubeUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ServerConfig {
    public static final ForgeConfigSpec SPEC;
    private static final ServerConfig INSTANCE;
    public final ForgeConfigSpec.EnumValue<EntityListMode> ENTITY_LIST_MODE;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_WHITELIST;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_BLACKLIST;
    public final ForgeConfigSpec.DoubleValue SPEED_MULTIPLIER;
    public final ForgeConfigSpec.DoubleValue STRESS_IMPACT_ENTRANCE;
    public final ForgeConfigSpec.DoubleValue STRESS_IMPACT_ACCELERATOR;
    private final Set<EntityType<?>> cachedWhitelist = new HashSet();
    private final Set<EntityType<?>> cachedBlacklist = new HashSet();

    private ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.comment("Change these settings to customize the server-side behavior of the mod.").push("Travel Settings");
        this.ENTITY_LIST_MODE = builder.comment(new String[]{"How to handle entity travel permissions:", "TAG_ONLY - Use only the 'create_hypertube:traveller_entities' tag from datapacks", "WHITELIST - Only entities in the whitelist can travel (ignores tag)", "BLACKLIST - All entities can travel except those in the blacklist", "TAG_WITH_BLACKLIST - Use tag but exclude entities in the blacklist"}).defineEnum("entityListMode", (Enum)EntityListMode.BLACKLIST);
        this.ENTITY_WHITELIST = builder.comment(new String[]{"Entities that CAN travel (only used when mode is WHITELIST).", "Use entity registry names like 'minecraft:villager' or 'create:package'"}).defineListAllowEmpty(List.of("entityWhitelist"), () -> List.of("minecraft:player", "minecraft:villager", "minecraft:wandering_trader", "create:package"), obj -> obj instanceof String);
        this.ENTITY_BLACKLIST = builder.comment(new String[]{"Entities that CANNOT travel (used in BLACKLIST and TAG_WITH_BLACKLIST modes).", "Use entity registry names like 'minecraft:creeper' or 'minecraft:wither'"}).defineListAllowEmpty(List.of("entityBlacklist"), () -> List.of("minecraft:wither", "minecraft:ender_dragon"), obj -> obj instanceof String);
        this.SPEED_MULTIPLIER = builder.comment("Multiplier for the speed of the tubes. Default is 1.0, which is normal speed. (THIS IS HIGHLY EXPERIMENTAL)").defineInRange("speedMultiplier", 1.0, 0.5, 99.0);
        builder.pop();
        builder.comment("Stress Settings").push("Stress Settings");
        this.STRESS_IMPACT_ENTRANCE = builder.comment("Stress impact of the Hyper Entrance block.").defineInRange("entranceStressImpact", 4.0, 0.0, 100.0);
        this.STRESS_IMPACT_ACCELERATOR = builder.comment("Stress impact of the Hyper Accelerator block.").defineInRange("acceleratorStressImpact", 4.0, 0.0, 100.0);
        builder.pop();
    }

    public static ServerConfig get() {
        return INSTANCE;
    }

    public void init() {
        this.loadEntityList((List)this.ENTITY_WHITELIST.get(), this.cachedWhitelist);
        this.loadEntityList((List)this.ENTITY_BLACKLIST.get(), this.cachedBlacklist);
        TubeUtils.SPEED_MULTIPLIER = ((Double)this.SPEED_MULTIPLIER.get()).floatValue();
    }

    private void loadEntityList(List<? extends String> entityIds, Set<EntityType<?>> targetSet) {
        targetSet.clear();
        for (String string : entityIds) {
            try {
                ResourceLocation location = ResourceLocation.m_135820_((String)string);
                EntityType entityType = (EntityType)BuiltInRegistries.f_256780_.m_7745_(location);
                if (entityType != null) {
                    targetSet.add(entityType);
                    continue;
                }
                System.err.println("[Hypertube] Unknown entity type in config: " + string);
            }
            catch (Exception e) {
                System.err.println("[Hypertube] Invalid entity ID in config: " + string + " - " + e.getMessage());
            }
        }
    }

    public static boolean canEntityTravel(EntityType<?> type) {
        boolean isInTag = type.m_204039_(TravelConstants.TRAVELLER_ENTITIES);
        return ServerConfig.get().canEntityTravel(type, isInTag);
    }

    public boolean canEntityTravel(EntityType<?> entityType, boolean isInTag) {
        return switch ((EntityListMode)((Object)this.ENTITY_LIST_MODE.get())) {
            default -> throw new IncompatibleClassChangeError();
            case EntityListMode.TAG_ONLY -> isInTag;
            case EntityListMode.WHITELIST -> this.cachedWhitelist.contains(entityType);
            case EntityListMode.BLACKLIST -> {
                if (!this.cachedBlacklist.contains(entityType)) {
                    yield true;
                }
                yield false;
            }
            case EntityListMode.TAG_WITH_BLACKLIST -> isInTag && !this.cachedBlacklist.contains(entityType);
        };
    }

    public Set<EntityType<?>> getWhitelist() {
        return this.cachedWhitelist;
    }

    public Set<EntityType<?>> getBlacklist() {
        return this.cachedBlacklist;
    }

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(ServerConfig::new);
        INSTANCE = (ServerConfig)pair.getLeft();
        SPEC = (ForgeConfigSpec)pair.getRight();
    }

    public static enum EntityListMode {
        TAG_ONLY,
        WHITELIST,
        BLACKLIST,
        TAG_WITH_BLACKLIST;

    }
}

