/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.events.subscribers.common;

import com.oe.rehooked.capabilities.hooks.ClientHookCapabilityProvider;
import com.oe.rehooked.capabilities.hooks.ServerHookCapabilityProvider;
import com.oe.rehooked.handlers.hook.def.IClientPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.ICommonPlayerHookHandler;
import com.oe.rehooked.handlers.hook.def.IServerPlayerHookHandler;
import com.oe.rehooked.utils.HandlerHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="rehooked", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ForgeEventBus {
    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            if (player.m_9236_().m_5776_()) {
                if (!IClientPlayerHookHandler.FromPlayer(player).isPresent()) {
                    event.addCapability(new ResourceLocation("rehooked", "capabilities.hook.client"), (ICapabilityProvider)new ClientHookCapabilityProvider());
                }
            } else if (!player.m_9236_().m_5776_() && !IServerPlayerHookHandler.FromPlayer(player).isPresent()) {
                event.addCapability(new ResourceLocation("rehooked", "capabilities.hook.server"), (ICapabilityProvider)new ServerHookCapabilityProvider());
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerQuit(PlayerEvent.PlayerLoggedOutEvent event) {
        IServerPlayerHookHandler.FromPlayer(event.getEntity()).ifPresent(ICommonPlayerHookHandler::removeAllHooks);
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        event.getServer().m_6846_().m_11314_().forEach(player -> IServerPlayerHookHandler.FromPlayer((Player)player).ifPresent(handler -> {
            handler.setOwner((Player)player).update();
            if (handler.shouldMoveThisTick()) {
                player.m_20256_(handler.getDeltaVThisTick());
            }
            handler.storeLastPlayerPosition();
        }));
    }

    @SubscribeEvent
    public static void onBreakEvent(PlayerEvent.BreakSpeed event) {
        Player player = event.getEntity();
        HandlerHelper.getHookHandler(player).ifPresent(handler -> {
            if (handler.countPulling() > 0) {
                int mult = (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player) ? 5 : 1) * (player.m_20096_() ? 1 : 5);
                event.setNewSpeed(event.getNewSpeed() * (float)mult);
            }
        });
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        HandlerHelper.getHookHandler(event.getEntity()).ifPresent(newHandler -> HandlerHelper.getHookHandler(event.getOriginal()).ifPresent(oldHandler -> {
            if (newHandler instanceof IServerPlayerHookHandler) {
                IServerPlayerHookHandler newServerHandler = (IServerPlayerHookHandler)newHandler;
                if (oldHandler instanceof IServerPlayerHookHandler) {
                    IServerPlayerHookHandler oldServerHandler = (IServerPlayerHookHandler)oldHandler;
                    oldServerHandler.removeAllHooks();
                    newServerHandler.copyFrom(oldServerHandler);
                    newHandler.setOwner(event.getEntity());
                    newHandler.afterDeath();
                }
            }
        }));
    }

    @SubscribeEvent
    public static void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.getEntity().m_9236_().m_5776_()) {
            return;
        }
        HandlerHelper.getHookHandler(event.getEntity()).ifPresent(handler -> {
            handler.getHooks().forEach(Entity::m_146870_);
            handler.getHooks().clear();
            handler.afterDeath();
        });
    }
}

