/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.entities.test;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.oe.rehooked.entities.layers.ReHookedModelLayers;
import com.oe.rehooked.entities.test.TestCubeEntity;
import com.oe.rehooked.entities.test.TestCubeModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class TestCubeRenderer
extends EntityRenderer<TestCubeEntity> {
    public static final ResourceLocation TEXTURE = new ResourceLocation("rehooked", "textures/test/direction_cube/test_cube.png");
    protected EntityRendererProvider.Context pContext;
    protected EntityModel<TestCubeEntity> model;
    protected float lastDelta = 0.0f;

    public TestCubeRenderer(EntityRendererProvider.Context pContext) {
        super(pContext);
        this.pContext = pContext;
        this.model = new TestCubeModel(pContext.m_174023_(ReHookedModelLayers.TEST_CUBE_LAYER));
    }

    public void render(TestCubeEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        this.handleCube(pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        this.handleChain(pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
        super.m_7392_((Entity)pEntity, pEntityYaw, pPartialTick, pPoseStack, pBuffer, pPackedLight);
    }

    private void handleCube(TestCubeEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252977_(-Minecraft.m_91087_().f_91074_.m_6080_() + 90.0f));
        pPoseStack.m_252781_(Axis.f_252403_.m_252977_(Minecraft.m_91087_().f_91074_.m_146909_()));
        pPoseStack.m_85837_(0.0, -0.5, 0.0);
        this.model.m_7695_(pPoseStack, pBuffer.m_6299_(this.model.m_103119_(this.getTextureLocation(pEntity))), pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        pPoseStack.m_85849_();
    }

    public boolean shouldRender(TestCubeEntity pLivingEntity, Frustum pCamera, double pCamX, double pCamY, double pCamZ) {
        return true;
    }

    private void handleChain(TestCubeEntity pEntity, float pEntityYaw, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight) {
        pPoseStack.m_85836_();
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        Vec3 waistPos = player.m_20182_().m_82520_(0.0, (double)player.m_20192_() / 1.5, 0.0);
        Vec3 cubePos = pEntity.m_20182_();
        Vec3 playerToCube = waistPos.m_82505_(cubePos);
        Vec3 normal = playerToCube.m_82541_();
        pPoseStack.m_252781_(Axis.f_252436_.m_252961_(1.5707964f - (float)Mth.m_14136_((double)normal.f_82481_, (double)normal.f_82479_)));
        pPoseStack.m_252781_(Axis.f_252529_.m_252961_((float)Math.acos(normal.f_82480_) - (float)Math.PI));
        pPoseStack.m_85837_(-0.5, 0.0, -0.75);
        float distance = (float)playerToCube.m_82553_();
        BlockState chain = Blocks.f_50184_.m_49966_();
        for (int i = 0; i < (int)distance; ++i) {
            this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
            pPoseStack.m_252880_(0.0f, 1.0f, 0.0f);
        }
        float delta = distance - (float)((int)distance);
        if (this.lastDelta - delta > 0.5f || this.lastDelta == 0.0f) {
            this.lastDelta = delta;
        }
        delta = Mth.m_14179_((float)pPartialTick, (float)this.lastDelta, (float)delta);
        pPoseStack.m_85841_(1.0f, delta, 1.0f);
        this.lastDelta = delta;
        this.pContext.m_234597_().m_110912_(chain, pPoseStack, pBuffer, pPackedLight, OverlayTexture.f_118083_);
        pPoseStack.m_85849_();
    }

    public ResourceLocation getTextureLocation(TestCubeEntity pEntity) {
        return TEXTURE;
    }
}

