/*
 * Decompiled with CFR 0.152.
 */
package com.oe.rehooked.config.server.stats;

import com.oe.rehooked.data.HookData;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.StringUtils;

public class HookStatsConfig {
    private static final Map<String, HookConfigData> HOOK_CONFIG_DATA_MAP = new HashMap<String, HookConfigData>();

    private static void createHookCategory(String hookType, ForgeConfigSpec.Builder builder, IncompleteHookData partialHookData) {
        builder.comment(StringUtils.capitalize((String)hookType) + " Hook Stats");
        builder.push(hookType);
        HookConfigData.create(builder, partialHookData.count(), partialHookData.range(), partialHookData.travelSpeed(), partialHookData.pullSpeed(), partialHookData.isCreative()).registerHookData(hookType);
        builder.pop();
    }

    public static void init(ForgeConfigSpec.Builder builder) {
        builder.push("hook_stats");
        HookStatsConfig.createHookCategory("wood", builder, new IncompleteHookData(1, 16.0f, 12.0f, 6.0f, false));
        HookStatsConfig.createHookCategory("iron", builder, new IncompleteHookData(2, 32.0f, 24.0f, 12.0f, false));
        HookStatsConfig.createHookCategory("diamond", builder, new IncompleteHookData(4, 64.0f, 48.0f, 24.0f, false));
        HookStatsConfig.createHookCategory("red", builder, new IncompleteHookData(3, 16.0f, 8.0f, 6.0f, true));
        HookStatsConfig.createHookCategory("blaze", builder, new IncompleteHookData(2, 64.0f, 1920.0f, 36.0f, false));
        HookStatsConfig.createHookCategory("ender", builder, new IncompleteHookData(1, 96.0f, 1920.0f, 48.0f, false));
        builder.pop();
    }

    public static Optional<HookConfigData> getConfigDataForType(String hookType) {
        return Optional.ofNullable(HOOK_CONFIG_DATA_MAP.get(hookType));
    }

    public record IncompleteHookData(int count, float range, float travelSpeed, float pullSpeed, boolean isCreative) {
        public HookData complete(String type, ResourceLocation texture, Supplier<ParticleOptions> particleType, int minParticlesPerBlock, int maxParticlesPerBlock, double radius, int ticksBetweenSpawns) {
            return new HookData(type, this.count, this.range, this.travelSpeed, this.pullSpeed, this.isCreative, texture, particleType, minParticlesPerBlock, maxParticlesPerBlock, radius, ticksBetweenSpawns);
        }
    }

    public static class HookConfigData {
        public final ForgeConfigSpec.IntValue COUNT;
        public final ForgeConfigSpec.DoubleValue RANGE;
        public final ForgeConfigSpec.DoubleValue SPEED;
        public final ForgeConfigSpec.DoubleValue PULL_SPEED;
        public final ForgeConfigSpec.BooleanValue IS_CREATIVE;

        public HookConfigData(ForgeConfigSpec.IntValue count, ForgeConfigSpec.DoubleValue range, ForgeConfigSpec.DoubleValue speed, ForgeConfigSpec.DoubleValue pullSpeed, ForgeConfigSpec.BooleanValue isCreative) {
            this.COUNT = count;
            this.RANGE = range;
            this.SPEED = speed;
            this.PULL_SPEED = pullSpeed;
            this.IS_CREATIVE = isCreative;
        }

        public static HookConfigData create(ForgeConfigSpec.Builder builder, int count, double range, double travelSpeed, double pullSpeed, boolean isCreative) {
            return new HookConfigData(builder.comment("The number of hooks").defineInRange("count", count, 1, Integer.MAX_VALUE), builder.comment("The hooks range").defineInRange("range", range, 1.0, Double.MAX_VALUE), builder.comment("The hooks shooting speed").defineInRange("travelSpeed", travelSpeed, 0.1, Double.MAX_VALUE), builder.comment("How fast the hook pulls the player").defineInRange("pullSpeed", pullSpeed, 0.1, Double.MAX_VALUE), builder.comment("Should the hook provide creative flight or not").define("creativeFlight", isCreative));
        }

        public void registerHookData(String hookType) {
            HOOK_CONFIG_DATA_MAP.put(hookType, this);
        }

        public IncompleteHookData getData() {
            return new IncompleteHookData((Integer)this.COUNT.get(), ((Double)this.RANGE.get()).floatValue(), ((Double)this.SPEED.get()).floatValue(), ((Double)this.PULL_SPEED.get()).floatValue(), (Boolean)this.IS_CREATIVE.get());
        }
    }
}

