/*
 * Decompiled with CFR 0.152.
 */
package com.darkere.crashutils.CrashUtilCommands.PlayerCommands;

import com.darkere.crashutils.CommandUtils;
import com.darkere.crashutils.DataStructures.PlayerActivityHistory;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.world.level.Level;

public class ActivityCommand {
    private static final SuggestionProvider<CommandSourceStack> sugg = (ctx, builder) -> SharedSuggestionProvider.m_82970_(Arrays.asList("week", "day", "month"), (SuggestionsBuilder)builder);

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"activity").executes(ActivityCommand::listActivity)).then(Commands.m_82129_((String)"time", (ArgumentType)StringArgumentType.word()).suggests(sugg).executes(ctx -> ActivityCommand.listActivityByDate((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"time"))));
    }

    private static int listActivity(CommandContext<CommandSourceStack> context) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSourceStack)context.getSource()).m_81372_());
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Number of Players active in the last:"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Day: " + history.getDay().size() + " unique players"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Week: " + history.getWeek().size() + " unique players"), false);
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Month: " + history.getMonth().size() + " unique players"), false);
        return 1;
    }

    private static int listActivityByDate(CommandContext<CommandSourceStack> context, String time) {
        PlayerActivityHistory history = new PlayerActivityHistory(((CommandSourceStack)context.getSource()).m_81377_().m_129880_(Level.f_46428_));
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent("Active Players in the last " + time), false);
        StringBuilder b = new StringBuilder();
        switch (time) {
            case "month": {
                history.getMonth().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "week": {
                history.getWeek().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
                break;
            }
            case "day": {
                history.getDay().forEach(x -> {
                    b.append((String)x);
                    b.append(", ");
                });
            }
        }
        ((CommandSourceStack)context.getSource()).m_288197_(() -> CommandUtils.CreateTextComponent(b.toString()), false);
        return 1;
    }
}

