/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.client;

import com.alc.moreminecarts.client.MMButton;
import com.alc.moreminecarts.containers.FlagCartContainer;
import com.alc.moreminecarts.proxy.MoreMinecartsPacketHandler;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class FlagCartScreen
extends AbstractContainerScreen<FlagCartContainer> {
    private static final ResourceLocation display = new ResourceLocation("moreminecarts:textures/gui/programmable_cart.png");
    private final List<SimpleButton> buttons = Lists.newArrayList();

    public FlagCartScreen(FlagCartContainer container, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)container, inv, (Component)Component.m_237115_((String)"Signal Minecart"));
    }

    private void addButton(SimpleButton p_169617_) {
        this.m_142416_((GuiEventListener)p_169617_);
        this.buttons.add(p_169617_);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addButton(new LeftButton(this.f_97735_ + 46, this.f_97736_ + 19));
        this.addButton(new MinusButton(this.f_97735_ + 68, this.f_97736_ + 19));
        this.addButton(new PlusButton(this.f_97735_ + 90, this.f_97736_ + 19));
        this.addButton(new RightButton(this.f_97735_ + 112, this.f_97736_ + 19));
    }

    public void m_88315_(GuiGraphics p_230430_1_, int p_230430_2_, int p_230430_3_, float p_230430_4_) {
        this.m_280273_(p_230430_1_);
        super.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        for (AbstractButton abstractButton : this.buttons) {
            abstractButton.m_88315_(p_230430_1_, p_230430_2_, p_230430_3_, p_230430_4_);
        }
        this.m_280072_(p_230430_1_, p_230430_2_, p_230430_3_);
    }

    protected void m_7286_(GuiGraphics matrix, float p_230450_2_, int p_230450_3_, int p_230450_4_) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
        matrix.m_280218_(display, this.f_97735_, this.f_97736_, 0, 0, 176, 166);
        for (int i = 0; i < ((FlagCartContainer)this.f_97732_).getDiscludedSlots(); ++i) {
            matrix.m_280218_(display, this.f_97735_ + 151 - 18 * i, this.f_97736_ + 41, 176, 36, 18, 18);
        }
        int s = ((FlagCartContainer)this.f_97732_).getSelectedSlot();
        matrix.m_280218_(display, this.f_97735_ + 4 + 18 * s, this.f_97736_ + 38, 194, 36, 24, 24);
    }

    class LeftButton
    extends SimpleButton {
        protected LeftButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(GuiGraphics matrix, int x, int y) {
            matrix.m_280218_(display, this.xPos, this.yPos, 194, 18, 18, 18);
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.FlagCartPacket packet = new MoreMinecartsPacketHandler.FlagCartPacket(false, true);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    abstract class SimpleButton
    extends MMButton {
        protected SimpleButton(int x, int y) {
            super(x, y);
        }

        public void m_87963_(GuiGraphics matrix, int x, int y, float p_230431_4_) {
            boolean mouse_on;
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)display);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean bl = mouse_on = FlagCartScreen.this.m_7282_() && this.f_93622_;
            if (mouse_on) {
                this.renderSelected(matrix, this.xPos, this.yPos);
            }
        }

        public abstract void renderSelected(GuiGraphics var1, int var2, int var3);

        @Override
        protected void m_168797_(NarrationElementOutput p_259858_) {
        }
    }

    class MinusButton
    extends SimpleButton {
        protected MinusButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(GuiGraphics matrix, int x, int y) {
            matrix.m_280218_(display, this.xPos, this.yPos, 230, 0, 18, 18);
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.FlagCartPacket packet = new MoreMinecartsPacketHandler.FlagCartPacket(true, false);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    class PlusButton
    extends SimpleButton {
        protected PlusButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(GuiGraphics matrix, int x, int y) {
            matrix.m_280218_(display, this.xPos, this.yPos, 194, 0, 18, 18);
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.FlagCartPacket packet = new MoreMinecartsPacketHandler.FlagCartPacket(false, false);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }

    class RightButton
    extends SimpleButton {
        protected RightButton(int x, int y) {
            super(x, y);
        }

        @Override
        public void renderSelected(GuiGraphics matrix, int x, int y) {
            matrix.m_280218_(display, this.xPos, this.yPos, 230, 18, 18, 18);
        }

        @Override
        public void m_5691_() {
            MoreMinecartsPacketHandler.FlagCartPacket packet = new MoreMinecartsPacketHandler.FlagCartPacket(true, true);
            MoreMinecartsPacketHandler.INSTANCE.sendToServer((Object)packet);
        }
    }
}

