/*
 * Decompiled with CFR 0.152.
 */
package com.alc.moreminecarts.blocks.utility_rails;

import com.alc.moreminecarts.entities.FlagCartEntity;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.AbstractMinecartContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RailState;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.AABB;

public class ColorDetectorRailBlock
extends BaseRailBlock {
    public static final EnumProperty<RailShape> SHAPE = BlockStateProperties.f_61404_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public Supplier<Item> detected_item;

    public ColorDetectorRailBlock(BlockBehaviour.Properties builder, Supplier<Item> det) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false)));
        this.detected_item = det;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (worldIn.m_5776_()) {
            return;
        }
        this.checkPressed(worldIn, pos, state);
    }

    public void m_213897_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource rand) {
        this.checkPressed((Level)worldIn, pos, state);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{SHAPE, POWERED, f_152149_});
    }

    private void checkPressed(Level worldIn, BlockPos pos, BlockState state) {
        if (this.m_7898_(state, (LevelReader)worldIn, pos)) {
            boolean was_powered = (Boolean)state.m_61143_((Property)POWERED);
            boolean activate = false;
            List<AbstractMinecart> list = this.findMinecarts(worldIn, pos, AbstractMinecart.class, entity -> true);
            if (!list.isEmpty()) {
                if (was_powered) {
                    activate = true;
                } else {
                    for (AbstractMinecart minecart : list) {
                        if (minecart.m_6064_() == AbstractMinecart.Type.RIDEABLE) {
                            Player player;
                            Entity entity2;
                            List passengers = minecart.m_20197_();
                            if (passengers.isEmpty() || !((entity2 = (Entity)passengers.get(0)) instanceof Player) || (player = (Player)entity2).m_21120_(InteractionHand.MAIN_HAND).m_41720_() != this.detected_item.get() && player.m_21120_(InteractionHand.OFF_HAND).m_41720_() != this.detected_item.get()) continue;
                            activate = true;
                            continue;
                        }
                        if (minecart instanceof FlagCartEntity) {
                            if (((FlagCartEntity)minecart).getSelectedFlag() != this.detected_item.get()) continue;
                            activate = true;
                            continue;
                        }
                        if (!(minecart instanceof AbstractMinecartContainer)) continue;
                        AbstractMinecartContainer container = (AbstractMinecartContainer)minecart;
                        HashSet<Item> set = new HashSet<Item>();
                        set.add(this.detected_item.get());
                        if (!container.m_18949_(set)) continue;
                        activate = true;
                    }
                }
            }
            if (activate && !was_powered) {
                BlockState blockstate = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
                worldIn.m_7731_(pos, blockstate, 3);
                this.updatePowerToConnected(worldIn, pos, blockstate, true);
                worldIn.m_46672_(pos, (Block)this);
                worldIn.m_46672_(pos.m_7495_(), (Block)this);
                worldIn.m_6550_(pos, state, blockstate);
            }
            if (!activate && was_powered) {
                BlockState blockstate1 = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
                worldIn.m_7731_(pos, blockstate1, 3);
                this.updatePowerToConnected(worldIn, pos, blockstate1, false);
                worldIn.m_46672_(pos, (Block)this);
                worldIn.m_46672_(pos.m_7495_(), (Block)this);
                worldIn.m_6550_(pos, state, blockstate1);
            }
            if (activate) {
                worldIn.m_186460_(pos, (Block)this, 20);
            }
            worldIn.m_46717_(pos, (Block)this);
        }
    }

    protected void updatePowerToConnected(Level worldIn, BlockPos pos, BlockState state, boolean powered) {
        RailState railstate = new RailState(worldIn, pos, state);
        for (BlockPos blockpos : railstate.m_55424_()) {
            BlockState blockstate = worldIn.m_8055_(blockpos);
            blockstate.m_60690_(worldIn, blockpos, blockstate.m_60734_(), pos, false);
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.m_60713_(state.m_60734_())) {
            this.checkPressed(worldIn, pos, this.m_49389_(state, worldIn, pos, isMoving));
        }
    }

    protected <T extends AbstractMinecart> List<T> findMinecarts(Level worldIn, BlockPos pos, Class<T> cartType, @Nullable Predicate<Entity> filter) {
        return worldIn.m_6443_(cartType, this.getDectectionBox(pos), filter);
    }

    private AABB getDectectionBox(BlockPos pos) {
        return new AABB((double)pos.m_123341_() + 0.2, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.2, (double)(pos.m_123341_() + 1) - 0.2, (double)(pos.m_123342_() + 1) - 0.2, (double)(pos.m_123343_() + 1) - 0.2);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public boolean m_7899_(BlockState p_149744_1_) {
        return true;
    }

    public int m_6378_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Boolean)blockState.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        if (!((Boolean)blockState.m_61143_((Property)POWERED)).booleanValue()) {
            return 0;
        }
        return side == Direction.UP ? 15 : 0;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                }
            }
            case COUNTERCLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
            case CLOCKWISE_90: {
                switch ((RailShape)state.m_61143_(SHAPE)) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.EAST_WEST);
                    }
                    case EAST_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_SOUTH);
                    }
                }
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        RailShape railshape = (RailShape)state.m_61143_(SHAPE);
        block0 : switch (mirrorIn) {
            case LEFT_RIGHT: {
                switch (railshape) {
                    case ASCENDING_NORTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_SOUTH);
                    }
                    case ASCENDING_SOUTH: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_NORTH);
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case NORTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                }
                return super.m_6943_(state, mirrorIn);
            }
            case FRONT_BACK: {
                switch (railshape) {
                    case ASCENDING_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_WEST);
                    }
                    case ASCENDING_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.ASCENDING_EAST);
                    }
                    default: {
                        break block0;
                    }
                    case SOUTH_EAST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_WEST);
                    }
                    case SOUTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.SOUTH_EAST);
                    }
                    case NORTH_WEST: {
                        return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_EAST);
                    }
                    case NORTH_EAST: 
                }
                return (BlockState)state.m_61124_(SHAPE, (Comparable)RailShape.NORTH_WEST);
            }
        }
        return super.m_6943_(state, mirrorIn);
    }

    public Property<RailShape> m_7978_() {
        return SHAPE;
    }
}

