/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry.datapack;

import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.datapack.WindsweptConfiguredFeatures;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.data.worldgen.features.VegetationFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.BlockPredicateFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.EnvironmentScanPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.NoiseThresholdCountPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RandomOffsetPlacement;
import net.minecraft.world.level.levelgen.placement.RarityFilter;

public final class WindsweptPlacedFeatures {
    public static final ResourceKey<PlacedFeature> RED_ROSE = WindsweptPlacedFeatures.createKey("red_rose");
    public static final ResourceKey<PlacedFeature> WHITE_ROSE = WindsweptPlacedFeatures.createKey("white_rose");
    public static final ResourceKey<PlacedFeature> LARGE_WHITE_ROSE = WindsweptPlacedFeatures.createKey("large_white_rose");
    public static final ResourceKey<PlacedFeature> BLUE_ROSE = WindsweptPlacedFeatures.createKey("blue_rose");
    public static final ResourceKey<PlacedFeature> YELLOW_ROSE = WindsweptPlacedFeatures.createKey("yellow_rose");
    public static final ResourceKey<PlacedFeature> FOXGLOVE = WindsweptPlacedFeatures.createKey("foxglove");
    public static final ResourceKey<PlacedFeature> YELLOW_PETALS = WindsweptPlacedFeatures.createKey("yellow_petals");
    public static final ResourceKey<PlacedFeature> RARE_YELLOW_PETALS = WindsweptPlacedFeatures.createKey("rare_yellow_petals");
    public static final ResourceKey<PlacedFeature> BLUEBELLS = WindsweptPlacedFeatures.createKey("bluebells");
    public static final ResourceKey<PlacedFeature> LAVENDER = WindsweptPlacedFeatures.createKey("lavender");
    public static final ResourceKey<PlacedFeature> LUPINE = WindsweptPlacedFeatures.createKey("lupine");
    public static final ResourceKey<PlacedFeature> LIONS_TAIL = WindsweptPlacedFeatures.createKey("lions_tail");
    public static final ResourceKey<PlacedFeature> COMMON_LIONS_TAIL = WindsweptPlacedFeatures.createKey("common_lions_tail");
    public static final ResourceKey<PlacedFeature> NIGHTHSADE = WindsweptPlacedFeatures.createKey("nightshade");
    public static final ResourceKey<PlacedFeature> WILD_BERRY_BUSH = WindsweptPlacedFeatures.createKey("wild_berry_bush");
    public static final ResourceKey<PlacedFeature> WILD_BERRY_BUSH_COMMON = WindsweptPlacedFeatures.createKey("wild_berry_bush_common");
    public static final ResourceKey<PlacedFeature> SNOWY_SPROUTS = WindsweptPlacedFeatures.createKey("snowy_sprouts");
    public static final ResourceKey<PlacedFeature> TALL_FERNS = WindsweptPlacedFeatures.createKey("tall_ferns");
    public static final ResourceKey<PlacedFeature> FERNS = WindsweptPlacedFeatures.createKey("ferns");
    public static final ResourceKey<PlacedFeature> GINGER_PATCH = WindsweptPlacedFeatures.createKey("ginger_patch");
    public static final ResourceKey<PlacedFeature> ICICLES = WindsweptPlacedFeatures.createKey("icicles");
    public static final ResourceKey<PlacedFeature> FLOOR_ICICLES = WindsweptPlacedFeatures.createKey("floor_icicles");
    public static final ResourceKey<PlacedFeature> RARE_HOLLY_TREES = WindsweptPlacedFeatures.createKey("rare_holly_trees");
    public static final ResourceKey<PlacedFeature> HOLLY_BUSH = WindsweptPlacedFeatures.createKey("holly_bush");
    public static final ResourceKey<PlacedFeature> HOLLY_TREES_ON_SNOW = WindsweptPlacedFeatures.createKey("holly_trees_on_snow");
    public static final ResourceKey<PlacedFeature> RARE_HOLLY_TREES_ON_SNOW = WindsweptPlacedFeatures.createKey("rare_holly_trees_on_snow");
    public static final ResourceKey<PlacedFeature> SPRUCE_TREES_ON_SNOW = WindsweptPlacedFeatures.createKey("spruce_trees_on_snow");
    public static final ResourceKey<PlacedFeature> CHESTNUT_TREES = WindsweptPlacedFeatures.createKey("chestnut_trees");
    public static final ResourceKey<PlacedFeature> RARE_CHESTNUT_TREES = WindsweptPlacedFeatures.createKey("rare_chestnut_trees");
    public static final ResourceKey<PlacedFeature> LAVENDER_CHESTNUT_TREES = WindsweptPlacedFeatures.createKey("lavender_chestnut_trees");
    public static final ResourceKey<PlacedFeature> TALL_BIRCH_TREES = WindsweptPlacedFeatures.createKey("tall_birch_trees");
    public static final ResourceKey<PlacedFeature> LAVENDER_TALL_BIRCH_TREES = WindsweptPlacedFeatures.createKey("lavender_tall_birch_trees");
    public static final ResourceKey<PlacedFeature> LAVENDER_FIELDS_TREES = WindsweptPlacedFeatures.createKey("lavender_fields_trees");
    public static final ResourceKey<PlacedFeature> PINE_TREES = WindsweptPlacedFeatures.createKey("pine_trees");
    public static final ResourceKey<PlacedFeature> PINE_CHECKED = WindsweptPlacedFeatures.createKey("pine_checked");
    public static final ResourceKey<PlacedFeature> FLOWERING_ACACIA_CHECKED = WindsweptPlacedFeatures.createKey("flowering_acacia_checked");
    public static final ResourceKey<PlacedFeature> OLD_GROWTH_PINE_TAIGA_TREES = WindsweptPlacedFeatures.createKey("old_growth_pine_taiga_trees");
    public static final ResourceKey<PlacedFeature> FLOWERING_SAVANNA_TREES = WindsweptPlacedFeatures.createKey("windswept_savanna_trees");
    public static final ResourceKey<PlacedFeature> RARE_FLOWERING_ACACIA_TREES = WindsweptPlacedFeatures.createKey("rare_flowering_acacia_trees");
    public static final ResourceKey<PlacedFeature> MEGA_SPRUCE_TREES = WindsweptPlacedFeatures.createKey("mega_spruce_trees");
    public static final ResourceKey<PlacedFeature> DRY_MOSS_PATCH_SMALL = WindsweptPlacedFeatures.createKey("dry_moss_patch_small");
    public static final ResourceKey<PlacedFeature> DRY_MOSS_PATCH_LARGE = WindsweptPlacedFeatures.createKey("dry_moss_patch_large");
    public static final ResourceKey<PlacedFeature> DRY_MOSS_ROCK = WindsweptPlacedFeatures.createKey("dry_moss_rock");
    public static final ResourceKey<PlacedFeature> GELISOL_PATCH = WindsweptPlacedFeatures.createKey("gelisol_patch_small");
    public static final ResourceKey<PlacedFeature> SNOWY_GELISOL = WindsweptPlacedFeatures.createKey("snowy_gelisol");
    public static final ResourceKey<PlacedFeature> TUNDRA_FALLEN_LOG = WindsweptPlacedFeatures.createKey("tundra_fallen_log");
    public static final ResourceKey<PlacedFeature> PINE_FALLEN_LOG = WindsweptPlacedFeatures.createKey("pine_fallen_log");
    public static final ResourceKey<PlacedFeature> LUSH_CAVES_VEGETATION = WindsweptPlacedFeatures.createKey("lush_caves_vegetation");
    public static final ResourceKey<PlacedFeature> SHALE = WindsweptPlacedFeatures.createKey("shale");

    public static void bootstrap(BootstapContext<PlacedFeature> context) {
        WindsweptPlacedFeatures.createPlantPatch(context, RED_ROSE, 16, WindsweptConfiguredFeatures.RED_ROSE);
        WindsweptPlacedFeatures.createPlantPatch(context, WHITE_ROSE, 20, WindsweptConfiguredFeatures.WHITE_ROSE);
        WindsweptPlacedFeatures.createPlantPatch(context, LARGE_WHITE_ROSE, 24, WindsweptConfiguredFeatures.LARGE_WHITE_ROSE);
        WindsweptPlacedFeatures.createPlantPatch(context, BLUE_ROSE, 16, WindsweptConfiguredFeatures.BLUE_ROSE);
        WindsweptPlacedFeatures.createPlantPatch(context, YELLOW_ROSE, 16, WindsweptConfiguredFeatures.YELLOW_ROSE);
        WindsweptPlacedFeatures.createPlantPatch(context, FOXGLOVE, 9, WindsweptConfiguredFeatures.FOXGLOVE);
        WindsweptPlacedFeatures.register(context, YELLOW_PETALS, WindsweptConfiguredFeatures.YELLOW_PETALS, new PlacementModifier[]{NoiseThresholdCountPlacement.m_191756_((double)-0.8, (int)5, (int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50440_}))});
        WindsweptPlacedFeatures.createPlantPatch(context, RARE_YELLOW_PETALS, 16, WindsweptConfiguredFeatures.YELLOW_PETALS);
        WindsweptPlacedFeatures.createPlantPatch(context, BLUEBELLS, 4, WindsweptConfiguredFeatures.BLUEBELLS);
        WindsweptPlacedFeatures.register(context, LAVENDER, WindsweptConfiguredFeatures.LAVENDER, new PlacementModifier[]{CountPlacement.m_191628_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.createPlantPatch(context, LUPINE, 12, WindsweptConfiguredFeatures.LUPINE);
        WindsweptPlacedFeatures.createPlantPatch(context, LIONS_TAIL, 22, WindsweptConfiguredFeatures.LIONS_TAIL);
        WindsweptPlacedFeatures.createPlantPatch(context, COMMON_LIONS_TAIL, 14, WindsweptConfiguredFeatures.LIONS_TAIL);
        WindsweptPlacedFeatures.createPlantPatch(context, NIGHTHSADE, 340, WindsweptConfiguredFeatures.NIGHTHSADE);
        WindsweptPlacedFeatures.createPlantPatch(context, WILD_BERRY_BUSH, 32, WindsweptConfiguredFeatures.WILD_BERRY_BUSH);
        WindsweptPlacedFeatures.createPlantPatch(context, WILD_BERRY_BUSH_COMMON, 5, WindsweptConfiguredFeatures.WILD_BERRY_BUSH);
        WindsweptPlacedFeatures.createPlantPatch(context, SNOWY_SPROUTS, 4, WindsweptConfiguredFeatures.SNOWY_SPROUTS);
        WindsweptPlacedFeatures.register(context, TALL_FERNS, VegetationFeatures.f_195189_, List.of(RarityFilter.m_191900_((int)5), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
        WindsweptPlacedFeatures.register(context, FERNS, WindsweptConfiguredFeatures.FERNS, new PlacementModifier[]{CountPlacement.m_191628_((int)10), InSquarePlacement.m_191715_(), PlacementUtils.f_195354_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, GINGER_PATCH, WindsweptConfiguredFeatures.GINGER_PATCH, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, ICICLES, WindsweptConfiguredFeatures.ICICLES, new PlacementModifier[]{PlacementUtils.m_195364_((int)4, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, FLOOR_ICICLES, WindsweptConfiguredFeatures.FLOOR_ICICLES, new PlacementModifier[]{PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, RARE_HOLLY_TREES, WindsweptConfiguredFeatures.HOLLY_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)1, (float)0.2f, (int)1)));
        WindsweptPlacedFeatures.register(context, HOLLY_BUSH, WindsweptConfiguredFeatures.HOLLY_BUSH, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)2)));
        WindsweptPlacedFeatures.register(context, HOLLY_TREES_ON_SNOW, WindsweptConfiguredFeatures.HOLLY_BEES, WindsweptPlacedFeatures.treeOnSnowPlacement(PlacementUtils.m_195364_((int)9, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, RARE_HOLLY_TREES_ON_SNOW, WindsweptConfiguredFeatures.HOLLY_BEES, WindsweptPlacedFeatures.treeOnSnowPlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, SPRUCE_TREES_ON_SNOW, VegetationFeatures.f_195160_, WindsweptPlacedFeatures.treeOnSnowPlacement(PlacementUtils.m_195364_((int)1, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, CHESTNUT_TREES, WindsweptConfiguredFeatures.CHESTNUT_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)9, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, RARE_CHESTNUT_TREES, WindsweptConfiguredFeatures.CHESTNUT_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, LAVENDER_CHESTNUT_TREES, WindsweptConfiguredFeatures.CHESTNUT_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, TALL_BIRCH_TREES, VegetationFeatures.f_195162_, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)5, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, LAVENDER_TALL_BIRCH_TREES, VegetationFeatures.f_195162_, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)4, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, LAVENDER_FIELDS_TREES, TreeFeatures.f_195108_, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)2)));
        WindsweptPlacedFeatures.register(context, PINE_TREES, WindsweptConfiguredFeatures.PINE_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)9, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, PINE_CHECKED, WindsweptConfiguredFeatures.PINE_BEES, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        WindsweptPlacedFeatures.register(context, FLOWERING_ACACIA_CHECKED, WindsweptConfiguredFeatures.FLOWERING_ACACIA_BEES, new PlacementModifier[]{PlacementUtils.m_206493_((Block)Blocks.f_50746_)});
        WindsweptPlacedFeatures.register(context, OLD_GROWTH_PINE_TAIGA_TREES, WindsweptConfiguredFeatures.OLD_GROWTH_PINE_TAIGA_TREES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, MEGA_SPRUCE_TREES, TreeFeatures.f_195133_, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)2)));
        WindsweptPlacedFeatures.register(context, FLOWERING_SAVANNA_TREES, WindsweptConfiguredFeatures.FLOWERING_SAVANNA_TREES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)2, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, RARE_FLOWERING_ACACIA_TREES, WindsweptConfiguredFeatures.FLOWERING_ACACIA_BEES, WindsweptPlacedFeatures.treePlacement(PlacementUtils.m_195364_((int)0, (float)0.1f, (int)1)));
        WindsweptPlacedFeatures.register(context, DRY_MOSS_PATCH_SMALL, WindsweptConfiguredFeatures.DRY_MOSS_PATCH_SMALL, new PlacementModifier[]{PlacementUtils.m_195364_((int)1, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, DRY_MOSS_PATCH_LARGE, WindsweptConfiguredFeatures.DRY_MOSS_PATCH_LARGE, new PlacementModifier[]{PlacementUtils.m_195364_((int)1, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, DRY_MOSS_ROCK, WindsweptConfiguredFeatures.DRY_MOSS_ROCK, new PlacementModifier[]{RarityFilter.m_191900_((int)3), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, GELISOL_PATCH, WindsweptConfiguredFeatures.GELISOL_PATCH, new PlacementModifier[]{PlacementUtils.m_195364_((int)1, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, SNOWY_GELISOL, WindsweptConfiguredFeatures.SNOWY_GELISOL, new PlacementModifier[]{PlacementUtils.m_195364_((int)10, (float)0.1f, (int)1), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, TUNDRA_FALLEN_LOG, WindsweptConfiguredFeatures.TUNDRA_FALLEN_LOG, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, PINE_FALLEN_LOG, WindsweptConfiguredFeatures.PINE_FALLEN_LOG, new PlacementModifier[]{PlacementUtils.m_195364_((int)0, (float)0.1f, (int)2), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_(), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, LUSH_CAVES_VEGETATION, WindsweptConfiguredFeatures.MOSS_PATCH, new PlacementModifier[]{CountPlacement.m_191628_((int)125), InSquarePlacement.m_191715_(), PlacementUtils.f_195360_, EnvironmentScanPlacement.m_191657_((Direction)Direction.DOWN, (BlockPredicate)BlockPredicate.m_190432_(), (BlockPredicate)BlockPredicate.f_190393_, (int)12), RandomOffsetPlacement.m_191877_((IntProvider)ConstantInt.m_146483_((int)1)), BiomeFilter.m_191561_()});
        WindsweptPlacedFeatures.register(context, SHALE, WindsweptConfiguredFeatures.SHALE, new PlacementModifier[]{PlacementUtils.m_195364_((int)2, (float)0.1f, (int)4), InSquarePlacement.m_191715_(), HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)64), (VerticalAnchor)VerticalAnchor.m_158922_((int)256)), BiomeFilter.m_191561_()});
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, List<PlacementModifier> modifiers) {
        context.m_255272_(key, (Object)new PlacedFeature((Holder)context.m_255420_(Registries.f_256911_).m_255043_(feature), modifiers));
    }

    private static void register(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, ResourceKey<ConfiguredFeature<?, ?>> feature, PlacementModifier ... modifiers) {
        WindsweptPlacedFeatures.register(context, key, feature, List.of(modifiers));
    }

    private static void createPlantPatch(BootstapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, int onceEvery, ResourceKey<ConfiguredFeature<?, ?>> feature) {
        WindsweptPlacedFeatures.register(context, key, feature, List.of(RarityFilter.m_191900_((int)onceEvery), InSquarePlacement.m_191715_(), PlacementUtils.f_195352_, BiomeFilter.m_191561_()));
    }

    private static ResourceKey<PlacedFeature> createKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256988_, (ResourceLocation)Windswept.location(name));
    }

    private static List<PlacementModifier> treePlacement(PlacementModifier modifier) {
        return List.of(modifier, InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BiomeFilter.m_191561_(), PlacementUtils.m_206493_((Block)Blocks.f_50746_));
    }

    private static List<PlacementModifier> treeOnSnowPlacement(PlacementModifier modifier) {
        return List.of(modifier, InSquarePlacement.m_191715_(), VegetationPlacements.f_195420_, PlacementUtils.f_195355_, BiomeFilter.m_191561_(), EnvironmentScanPlacement.m_191653_((Direction)Direction.UP, (BlockPredicate)BlockPredicate.m_190402_((BlockPredicate)BlockPredicate.m_224780_((Block[])new Block[]{Blocks.f_152499_})), (int)8), BlockPredicateFilter.m_191576_((BlockPredicate)BlockPredicate.m_224774_((Vec3i)Direction.DOWN.m_122436_(), (Block[])new Block[]{Blocks.f_50127_, Blocks.f_152499_})));
    }
}

