/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.registry.datapack;

import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.other.tags.WindsweptBiomeTags;
import com.rosemods.windswept.core.registry.WindsweptEntityTypes;
import com.rosemods.windswept.core.registry.datapack.WindsweptPlacedFeatures;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.CavePlacements;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ForgeBiomeModifiers;
import net.minecraftforge.registries.ForgeRegistries;

public final class WindsweptBiomeModifiers {
    public static void bootstrap(BootstapContext<BiomeModifier> context) {
        WindsweptBiomeModifiers.addFeature(context, "bluebells", WindsweptBiomeTags.HAS_BLUEBELLS, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.BLUEBELLS);
        WindsweptBiomeModifiers.addFeature(context, "snowy_sprouts", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.SNOWY_SPROUTS);
        WindsweptBiomeModifiers.addFeature(context, "foxgloves", (TagKey<Biome>)BiomeTags.f_207609_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.FOXGLOVE);
        WindsweptBiomeModifiers.addFeature(context, "grove_holly_trees", (ResourceKey<Biome>)Biomes.f_186755_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.HOLLY_TREES_ON_SNOW, WindsweptPlacedFeatures.SPRUCE_TREES_ON_SNOW);
        WindsweptBiomeModifiers.addFeature(context, "wild_berries", WindsweptBiomeTags.HAS_WILD_BERRIES, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.WILD_BERRY_BUSH);
        WindsweptBiomeModifiers.addFeature(context, "common_wild_berries", (ResourceKey<Biome>)Biomes.f_186755_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.WILD_BERRY_BUSH_COMMON);
        WindsweptBiomeModifiers.addFeature(context, "nightshades", (TagKey<Biome>)BiomeTags.f_215817_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.NIGHTHSADE);
        WindsweptBiomeModifiers.addFeature(context, "rare_chestnut_trees", WindsweptBiomeTags.HAS_RARE_CHESTNUT_TREES, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RARE_CHESTNUT_TREES);
        WindsweptBiomeModifiers.addFeature(context, "rare_holly_trees", WindsweptBiomeTags.HAS_RARE_HOLLY_TREES, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RARE_HOLLY_TREES);
        WindsweptBiomeModifiers.addFeature(context, "rare_snowy_holly_trees", WindsweptBiomeTags.HAS_RARE_SNOWY_HOLLY_TREES, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RARE_HOLLY_TREES_ON_SNOW);
        WindsweptBiomeModifiers.addFeature(context, "icicles", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.ICICLES, WindsweptPlacedFeatures.FLOOR_ICICLES);
        WindsweptBiomeModifiers.addFeature(context, "shale", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, GenerationStep.Decoration.UNDERGROUND_ORES, WindsweptPlacedFeatures.SHALE);
        WindsweptBiomeModifiers.addFeature(context, "red_roses", WindsweptBiomeTags.HAS_RED_ROSE, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RED_ROSE);
        WindsweptBiomeModifiers.addFeature(context, "blue_roses", WindsweptBiomeTags.HAS_BLUE_ROSE, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.BLUE_ROSE);
        WindsweptBiomeModifiers.addFeature(context, "white_roses", WindsweptBiomeTags.HAS_WHITE_ROSE, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.WHITE_ROSE);
        WindsweptBiomeModifiers.addFeature(context, "yellow_roses", WindsweptBiomeTags.HAS_YELLOW_ROSE, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.YELLOW_ROSE);
        WindsweptBiomeModifiers.addFeature(context, "lush_caves_moss", (ResourceKey<Biome>)Biomes.f_151785_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LUSH_CAVES_VEGETATION);
        WindsweptBiomeModifiers.addFeature(context, "old_growth_pine_taiga_trees", (ResourceKey<Biome>)Biomes.f_186763_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.OLD_GROWTH_PINE_TAIGA_TREES);
        WindsweptBiomeModifiers.addFeature(context, "rare_flowering_acacia_trees", (TagKey<Biome>)BiomeTags.f_215816_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RARE_FLOWERING_ACACIA_TREES);
        WindsweptBiomeModifiers.addFeature(context, "lions_tails", WindsweptBiomeTags.HAS_LIONS_TAIL, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.LIONS_TAIL);
        WindsweptBiomeModifiers.addFeature(context, "rare_yellow_petals", (TagKey<Biome>)BiomeTags.f_215816_, GenerationStep.Decoration.VEGETAL_DECORATION, WindsweptPlacedFeatures.RARE_YELLOW_PETALS);
        WindsweptBiomeModifiers.addSpawn(context, "chilled", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, new MobSpawnSettings.SpawnerData((EntityType)WindsweptEntityTypes.CHILLED.get(), 5, 3, 7));
        WindsweptBiomeModifiers.addSpawn(context, "frostbiter", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, new MobSpawnSettings.SpawnerData((EntityType)WindsweptEntityTypes.FROSTBITER.get(), 3, 1, 3));
        WindsweptBiomeModifiers.removeFeature(context, "grove_spruce_trees", (ResourceKey<Biome>)Biomes.f_186755_, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195429_);
        WindsweptBiomeModifiers.removeFeature(context, "taiga_default_flowers", (TagKey<Biome>)BiomeTags.f_207609_, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195415_);
        WindsweptBiomeModifiers.removeFeature(context, "snowy_default_flowers", (TagKey<Biome>)Tags.Biomes.IS_SNOWY, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195415_);
        WindsweptBiomeModifiers.removeFeature(context, "lush_caves_moss", (ResourceKey<Biome>)Biomes.f_151785_, GenerationStep.Decoration.VEGETAL_DECORATION, CavePlacements.f_195246_);
        WindsweptBiomeModifiers.removeFeature(context, "old_growth_pine_taiga_trees", (ResourceKey<Biome>)Biomes.f_186763_, GenerationStep.Decoration.VEGETAL_DECORATION, VegetationPlacements.f_195443_);
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        WindsweptBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), WindsweptBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void addFeature(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        WindsweptBiomeModifiers.register(context, "add_feature/" + name, () -> new ForgeBiomeModifiers.AddFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), WindsweptBiomeModifiers.featureSet(context, features), step));
    }

    @SafeVarargs
    private static void removeFeature(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        WindsweptBiomeModifiers.register(context, "removed_features/" + name, () -> new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), WindsweptBiomeModifiers.featureSet(context, features), Set.of(step)));
    }

    @SafeVarargs
    private static void removeFeature(BootstapContext<BiomeModifier> context, String name, ResourceKey<Biome> biome, GenerationStep.Decoration step, ResourceKey<PlacedFeature> ... features) {
        WindsweptBiomeModifiers.register(context, "removed_features/" + name, () -> new ForgeBiomeModifiers.RemoveFeaturesBiomeModifier((HolderSet)HolderSet.m_205809_((Holder[])new Holder[]{context.m_255420_(Registries.f_256952_).m_255043_(biome)}), WindsweptBiomeModifiers.featureSet(context, features), Set.of(step)));
    }

    private static void addSpawn(BootstapContext<BiomeModifier> context, String name, TagKey<Biome> biomes, MobSpawnSettings.SpawnerData ... spawns) {
        WindsweptBiomeModifiers.register(context, "add_spawn/" + name, () -> new ForgeBiomeModifiers.AddSpawnsBiomeModifier((HolderSet)context.m_255420_(Registries.f_256952_).m_254956_(biomes), List.of(spawns)));
    }

    private static void register(BootstapContext<BiomeModifier> context, String name, Supplier<? extends BiomeModifier> modifier) {
        context.m_255272_(ResourceKey.m_135785_((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIERS, (ResourceLocation)Windswept.location(name)), (Object)modifier.get());
    }

    @SafeVarargs
    private static HolderSet<PlacedFeature> featureSet(BootstapContext<?> context, ResourceKey<PlacedFeature> ... features) {
        return HolderSet.m_205800_(Stream.of(features).map(placedFeatureKey -> context.m_255420_(Registries.f_256988_).m_255043_(placedFeatureKey)).collect(Collectors.toList()));
    }
}

