/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.other.events;

import com.rosemods.windswept.client.render.entity.ChilledRenderer;
import com.rosemods.windswept.client.render.entity.FrostArrowRenderer;
import com.rosemods.windswept.client.render.entity.FrostbiterRenderer;
import com.rosemods.windswept.client.render.gui.CarvedPineconeOverlay;
import com.rosemods.windswept.core.other.WindsweptModelLayers;
import com.rosemods.windswept.core.registry.WindsweptBlockEntities;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEntityTypes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.core.util.DataUtil;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.blockentity.BrushableBlockRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(modid="windswept", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class WindsweptClientEvents {
    private static final List<RegistryObject<Block>> FOLIAGE_COLOR_BLOCKS = Arrays.asList(WindsweptBlocks.CHESTNUT_LEAVES, WindsweptBlocks.CHESTNUT_LEAF_PILE, WindsweptBlocks.FLOWERING_ACACIA_LEAVES, WindsweptBlocks.FLOWERING_ACACIA_LEAF_PILE);
    private static final List<RegistryObject<Block>> GRASS_COLOR_BLOCKS = Arrays.asList(WindsweptBlocks.YELLOW_PETALS);

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((s, c) -> c > 0 ? -1 : ((DyeableLeatherItem)s.m_41720_()).m_41121_(s), new ItemLike[]{(ItemLike)WindsweptItems.SNOW_BOOTS.get()});
        DataUtil.registerBlockItemColor((ItemColors)event.getItemColors(), (stack, c) -> event.getBlockColors().m_92577_(((BlockItem)stack.m_41720_()).m_40614_().m_49966_(), null, null, c), FOLIAGE_COLOR_BLOCKS);
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block event) {
        DataUtil.registerBlockColor((BlockColors)event.getBlockColors(), (state, tint, pos, u) -> pos != null && tint != null ? BiomeColors.m_108804_((BlockAndTintGetter)tint, (BlockPos)pos) : FoliageColor.m_46113_(), FOLIAGE_COLOR_BLOCKS);
        DataUtil.registerBlockColor((BlockColors)event.getBlockColors(), (state, tint, pos, u) -> pos != null && tint != null ? BiomeColors.m_108793_((BlockAndTintGetter)tint, (BlockPos)pos) : GrassColor.m_276205_(), GRASS_COLOR_BLOCKS);
    }

    @SubscribeEvent
    public static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.FROSTBITE.id(), "carved_pinecone", (IGuiOverlay)new CarvedPineconeOverlay());
    }

    @SubscribeEvent
    public static void registerLayerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(WindsweptModelLayers.CHILLED, WindsweptModelLayers::createChilledBodyLayer);
        event.registerLayerDefinition(WindsweptModelLayers.FROSTBITER, WindsweptModelLayers::createFrostbiterBodyLayer);
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)WindsweptEntityTypes.CHILLED.get(), ChilledRenderer::new);
        event.registerEntityRenderer((EntityType)WindsweptEntityTypes.FROSTBITER.get(), FrostbiterRenderer::new);
        event.registerEntityRenderer((EntityType)WindsweptEntityTypes.FROST_ARROW.get(), FrostArrowRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)WindsweptBlockEntities.SUSPICIOUS_SNOW.get(), BrushableBlockRenderer::new);
    }
}

