/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.mixin;

import com.rosemods.windswept.core.registry.WindsweptBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SnowyDirtBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SnowyDirtBlock.class})
public abstract class SnowyDirtBlockMixin
extends Block {
    private SnowyDirtBlockMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    public void updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> info) {
        info.setReturnValue((Object)(facing == Direction.UP ? (BlockState)state.m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(SnowyDirtBlockMixin.isSnowy(facingState, level, currentPos))) : state));
    }

    @Inject(method={"getStateForPlacement"}, at={@At(value="HEAD")}, cancellable=true)
    public void getStateForPlacement(BlockPlaceContext context, CallbackInfoReturnable<BlockState> info) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState above = level.m_8055_(pos.m_7494_());
        info.setReturnValue((Object)((BlockState)this.m_49966_().m_61124_((Property)SnowyDirtBlock.f_56637_, (Comparable)Boolean.valueOf(SnowyDirtBlockMixin.isSnowy(above, (LevelAccessor)level, pos)))));
    }

    @Unique
    private static boolean isSnowy(BlockState state, LevelAccessor level, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144279_) && SnowyDirtBlockMixin.m_49863_((LevelReader)level, (BlockPos)pos.m_7494_(), (Direction)Direction.DOWN) || state.m_60713_((Block)WindsweptBlocks.SNOWY_SPROUTS.get()) || state.m_60713_((Block)WindsweptBlocks.SNOWDROP.get());
    }
}

