/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.mixin;

import com.rosemods.windswept.common.entity.variant.WindsweptGoatVariant;
import com.rosemods.windswept.core.other.tags.WindsweptBiomeTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Goat.class})
public abstract class GoatMixin
extends Animal
implements VariantHolder<WindsweptGoatVariant> {
    protected GoatMixin(EntityType<? extends Animal> type, Level level) {
        super(type, level);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(CallbackInfo info) {
        this.f_19804_.m_135372_(WindsweptGoatVariant.DATA_TYPE_ID, (Object)WindsweptGoatVariant.WHITE.id());
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        tag.m_128405_("GoatType", ((Integer)this.f_19804_.m_135370_(WindsweptGoatVariant.DATA_TYPE_ID)).intValue());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo info) {
        this.f_19804_.m_135381_(WindsweptGoatVariant.DATA_TYPE_ID, (Object)tag.m_128451_("GoatType"));
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, SpawnGroupData spawnData, CompoundTag tag, CallbackInfoReturnable<SpawnGroupData> info) {
        this.f_19804_.m_135381_(WindsweptGoatVariant.DATA_TYPE_ID, (Object)(level.m_204166_(this.m_20183_()).m_203656_(WindsweptBiomeTags.HAS_BROWN_GOAT) ? 1 : 0));
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/animal/goat/Goat;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBreedOffspring(ServerLevel level, AgeableMob partner, CallbackInfoReturnable<Goat> info) {
        Goat baby = (Goat)info.getReturnValue();
        WindsweptGoatVariant variant = this.getVariant();
        ((VariantHolder)baby).m_28464_((Object)(variant.id() == ((WindsweptGoatVariant)((Object)((VariantHolder)partner).m_28554_())).id() ? variant : WindsweptGoatVariant.GRAY));
        info.setReturnValue((Object)baby);
    }

    public void setVariant(WindsweptGoatVariant variant) {
        this.f_19804_.m_135381_(WindsweptGoatVariant.DATA_TYPE_ID, (Object)variant.id());
    }

    public WindsweptGoatVariant getVariant() {
        return WindsweptGoatVariant.byId((Integer)this.f_19804_.m_135370_(WindsweptGoatVariant.DATA_TYPE_ID));
    }
}

