/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.server.modifiers;

import com.rosemods.windswept.core.data.server.WindsweptDatapackProvider;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptEntityTypes;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.teamabnormals.blueprint.common.advancement.modification.AdvancementModifierProvider;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.CriteriaModifier;
import com.teamabnormals.blueprint.common.advancement.modification.modifiers.EffectsChangedModifier;
import com.teamabnormals.blueprint.core.util.modification.ObjectModifier;
import java.util.List;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.ConsumeItemTrigger;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.KilledTrigger;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.core.HolderLookup;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class WindsweptAdvancementModifierProvider
extends AdvancementModifierProvider {
    public WindsweptAdvancementModifierProvider(GatherDataEvent event, WindsweptDatapackProvider dataPack) {
        super("windswept", event.getGenerator().getPackOutput(), dataPack.getRegistryProvider());
    }

    protected void registerEntries(HolderLookup.Provider provider) {
        List<Block> seedsBlocks = List.of((Block)WindsweptBlocks.WILD_BERRY_BUSH.get());
        List<EntityType<?>> killedMobs = List.of((EntityType)WindsweptEntityTypes.CHILLED.get());
        this.entry("balanced_diet").selects(new String[]{"husbandry/balanced_diet"}).addModifier((ObjectModifier)this.food().requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("all_effects").selects(new String[]{"nether/all_effects"}).addModifier((ObjectModifier)new EffectsChangedModifier("all_effects", false, this.effects()), new ICondition[0]);
        this.entry("plant_seed").selects(new String[]{"husbandry/plant_seed"}).addModifier((ObjectModifier)this.seedsBlocks(seedsBlocks).addIndexedRequirements(0, false, this.getNames(ForgeRegistries.BLOCKS, seedsBlocks)).build(), new ICondition[0]);
        this.entry("kill_a_mob").selects(new String[]{"adventure/kill_a_mob"}).addModifier((ObjectModifier)this.killedMobs(killedMobs).addIndexedRequirements(0, false, this.getNames(ForgeRegistries.ENTITY_TYPES, killedMobs)).build(), new ICondition[0]);
        this.entry("kill_all_mobs").selects(new String[]{"adventure/kill_all_mobs"}).addModifier((ObjectModifier)this.killedMobs(killedMobs).requirements(RequirementsStrategy.f_15978_).build(), new ICondition[0]);
        this.entry("walk_on_powder_snow_with_leather_boots").selects(new String[]{"adventure/walk_on_powder_snow_with_leather_boots"}).addModifier((ObjectModifier)this.snowBoots().addIndexedRequirements(0, false, new String[]{"snow_boots"}).build(), new ICondition[0]);
    }

    private CriteriaModifier.Builder builder() {
        return CriteriaModifier.builder((String)this.modId);
    }

    private <T> String[] getNames(IForgeRegistry<T> registry, List<? extends T> listIn) {
        String[] names = new String[listIn.size()];
        for (int i = 0; i < listIn.size(); ++i) {
            names[i] = registry.getKey(listIn.get(i)).m_135815_();
        }
        return names;
    }

    private CriteriaModifier.Builder food() {
        CriteriaModifier.Builder food = this.builder();
        WindsweptItems.HELPER.getDeferredRegister().getEntries().forEach(i -> {
            if (((Item)i.get()).m_41473_() != null) {
                food.addCriterion(ForgeRegistries.ITEMS.getKey((Object)((Item)i.get())).m_135815_(), (CriterionTriggerInstance)ConsumeItemTrigger.TriggerInstance.m_23703_((ItemLike)((ItemLike)i.get())));
            }
        });
        return food;
    }

    private MobEffectsPredicate effects() {
        MobEffectsPredicate effects = MobEffectsPredicate.m_56552_();
        WindsweptEffects.HELPER.getDeferredRegister().getEntries().forEach(e -> effects.m_56553_((MobEffect)e.get()));
        return effects;
    }

    private CriteriaModifier.Builder seedsBlocks(List<Block> seedsBlocksIn) {
        CriteriaModifier.Builder seedsBlocks = this.builder();
        seedsBlocksIn.forEach(s -> seedsBlocks.addCriterion(ForgeRegistries.BLOCKS.getKey(s).m_135815_(), (CriterionTriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.m_286031_((Block)s)));
        return seedsBlocks;
    }

    private CriteriaModifier.Builder killedMobs(List<EntityType<?>> killedMobsIn) {
        CriteriaModifier.Builder killedMobs = this.builder();
        killedMobsIn.forEach(e -> killedMobs.addCriterion(ForgeRegistries.ENTITY_TYPES.getKey(e).m_135815_(), (CriterionTriggerInstance)KilledTrigger.TriggerInstance.m_48134_((EntityPredicate.Builder)EntityPredicate.Builder.m_36633_().m_36636_(e))));
        return killedMobs;
    }

    private CriteriaModifier.Builder snowBoots() {
        return this.builder().addCriterion("snow_boots", (CriterionTriggerInstance)PlayerTrigger.TriggerInstance.m_222637_((Block)Blocks.f_152499_, (Item)((Item)WindsweptItems.SNOW_BOOTS.get())));
    }
}

