/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.core.data.client;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.rosemods.windswept.core.Windswept;
import com.rosemods.windswept.core.registry.WindsweptAttributes;
import com.rosemods.windswept.core.registry.WindsweptBlocks;
import com.rosemods.windswept.core.registry.WindsweptEffects;
import com.rosemods.windswept.core.registry.WindsweptEnchantments;
import com.rosemods.windswept.core.registry.WindsweptItems;
import com.rosemods.windswept.core.registry.WindsweptPaintingVariants;
import com.rosemods.windswept.core.registry.datapack.WindsweptBiomes;
import com.rosemods.windswept.core.registry.datapack.WindsweptDamageTypes;
import com.rosemods.windswept.core.registry.datapack.WindsweptTrimMaterials;
import com.rosemods.windswept.integration.jei.WindsweptPlugin;
import com.teamabnormals.blueprint.common.block.sign.BlueprintStandingSignBlock;
import com.teamabnormals.blueprint.common.block.sign.BlueprintWallSignBlock;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.data.LanguageProvider;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.codehaus.plexus.util.StringUtils;

public class WindsweptLangProvider
extends LanguageProvider {
    private final List<String> keys = Lists.newArrayList();

    public WindsweptLangProvider(GatherDataEvent event) {
        super(event.getGenerator().getPackOutput(), "windswept", "en_us");
    }

    protected void addTranslations() {
        this.add((Item)((RegistryObject)WindsweptItems.HOLLY_BOAT.getSecond()).get(), "Holly Boat with Chest");
        this.add((Item)((RegistryObject)WindsweptItems.CHESTNUT_BOAT.getSecond()).get(), "Chestnut Boat with Chest");
        this.add((Item)((RegistryObject)WindsweptItems.PINE_BOAT.getSecond()).get(), "Pine Boat with Chest");
        this.add((Item)WindsweptItems.GOAT.get(), "Raw Chevon");
        this.add((Item)WindsweptItems.COOKED_GOAT.get(), "Cooked Chevon");
        this.add((Item)WindsweptItems.HOLLY_BERRIES_ON_A_STICK.get(), "Holly Berries on a Stick");
        this.translateBannerPattern(WindsweptItems.SNOW_CHARGE_BANNER_PATTERN, "snow_charge");
        this.translateBannerPattern(WindsweptItems.SNOW_GOLEM_BANNER_PATTERN, "snow_golem");
        this.translateBannerPattern(WindsweptItems.ROSE_FLOWER_BANNER_PATTERN, "rose_flower");
        this.translateMusicDisc(WindsweptItems.MUSIC_DISC_RAIN, "rose - rain");
        this.translateMusicDisc(WindsweptItems.MUSIC_DISC_SNOW, "rose - snow");
        this.translateMusicDisc(WindsweptItems.MUSIC_DISC_BUMBLEBEE, "rose - bumblebee");
        this.add((Item)WindsweptItems.HOLLY_FURNACE_BOAT.get(), "Holly Boat with Furnace");
        this.add((Item)WindsweptItems.CHESTNUT_FURNACE_BOAT.get(), "Chestnut Boat with Furnace");
        this.add((Item)WindsweptItems.PINE_FURNACE_BOAT.get(), "Pine Boat with Furnace");
        this.addDescription(WindsweptItems.FEATHER_CLOAK, "Wearer will become invisible whilst crouching");
        this.translateSign(WindsweptBlocks.HOLLY_SIGNS, "holly");
        this.add((Block)WindsweptBlocks.HOLLY_LEAF_PILE.get(), "Pile of Holly Leaves");
        this.add((Block)WindsweptBlocks.HOLLY_BERRY_BASKET.get(), "Basket of Holly Berries");
        this.translateSign(WindsweptBlocks.CHESTNUT_SIGNS, "chestnut");
        this.add((Block)WindsweptBlocks.CHESTNUT_LEAF_PILE.get(), "Pile of Chestnut Leaves");
        this.add((Block)WindsweptBlocks.CHESTNUT_CRATE.get(), "Crate of Chestnuts");
        this.add((Block)WindsweptBlocks.ROASTED_CHESTNUT_CRATE.get(), "Crate of Roasted Chestnuts");
        this.translateSign(WindsweptBlocks.PINE_SIGNS, "pine");
        this.add((Block)WindsweptBlocks.PINE_LEAF_PILE.get(), "Pile of Pine Leaves");
        this.add((Block)WindsweptBlocks.FLOWERING_ACACIA_LEAF_PILE.get(), "Pile of Flowering Acacia Leaves");
        this.add((Block)WindsweptBlocks.WILL_O_THE_WISP.get(), "Will o' the Wisp");
        this.add("block.windswept.snow_carpet", "Snow Carpet");
        this.add((Block)WindsweptBlocks.GINGER_ROOT_CRATE.get(), "Crate of Ginger Roots");
        this.add((Block)WindsweptBlocks.WILD_BERRY_BASKET.get(), "Basket of Wild Berries");
        this.add((Block)WindsweptBlocks.LIONS_TAIL.get(), "Lion's Tail");
        this.translateEffect(WindsweptEffects.THORNS, "Causes damage to enemies when they attack you.");
        this.translateEffect(WindsweptEffects.FROST_RESISTANCE, "Grants immunity to frost. Allows for walking on Powder Snow. Stops Entity Conversion in Powder Snow.");
        this.translatePotion(WindsweptEffects.THORNS_POTION, "Prickling");
        this.translatePotion(WindsweptEffects.LONG_THORNS_POTION, "Prickling");
        this.translatePotion(WindsweptEffects.STRONG_THORNS_POTION, "Prickling");
        this.translatePotion(WindsweptEffects.FROST_RESISTANCE_POTION, "Frost Resistance");
        this.translatePotion(WindsweptEffects.LONG_FROST_RESISTANCE_POTION, "Frost Resistance");
        this.translateAttribute(WindsweptAttributes.SNOW_SPEED);
        this.translateAttribute(WindsweptAttributes.FRAGRANCE);
        this.add(((Attribute)WindsweptAttributes.SPRINT_DAMAGE.get()).m_22087_(), "Kinetic Damage");
        this.translateEnchantment(WindsweptEnchantments.SLIPPING_CURSE, "Curse of Slipping", "Causes the wearer to slip on any block as if it was ice whilst damaging the boots.");
        this.translateDamageType(WindsweptDamageTypes.HOLLY_LEAVES, player -> player + " was ripped to death by holly leaves", (player, entity) -> player + " was ripped to death by holly leaves whilst trying to escape " + entity);
        this.translateDamageType(WindsweptDamageTypes.ICICLE, player -> player + " was impaled on an icicle", (player, entity) -> player + " was impaled on an icicle whilst trying to escape " + entity);
        this.translateTrimMaterial(WindsweptTrimMaterials.ICICLES, "Icicles Material");
        this.translateTrimMaterial(WindsweptTrimMaterials.PINECONE, "Pinecone Material");
        this.translatePainting(WindsweptPaintingVariants.CLIFFSIDE, "Binome");
        this.translatePainting(WindsweptPaintingVariants.DRESS_CODES, "Yapettoshen");
        this.translatePainting(WindsweptPaintingVariants.ECOTONAL_PAREIDOLIA, "Yapettoshen");
        this.translatePainting(WindsweptPaintingVariants.THE_FOILS, "Yapettoshen");
        this.translatePainting(WindsweptPaintingVariants.AURORAE, "Yapettoshen");
        this.translatePainting(WindsweptPaintingVariants.HEARTH_RUG, "Yapettoshen");
        this.translatePainting(WindsweptPaintingVariants.ALLU_PINE, "Yapettoshen");
        this.translateBiome(WindsweptBiomes.CHESTNUT_FOREST);
        this.translateBiome(WindsweptBiomes.SNOWY_CHESTNUT_FOREST);
        this.translateBiome(WindsweptBiomes.PINE_BARRENS);
        this.translateBiome(WindsweptBiomes.SNOWY_PINE_BARRENS);
        this.translateBiome(WindsweptBiomes.LAVENDER_HILLS);
        this.translateBiome(WindsweptBiomes.LAVENDER_FIELDS);
        this.translateBiome(WindsweptBiomes.TUNDRA);
        this.translateBiome(WindsweptBiomes.FLOWERING_SAVANNA);
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.FROZEN_BRANCH, "Tamed Frostbiters will shed their antlers.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.ELDER_FEATHER, "Elder Feathers can be found via Archaeology.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.MUSIC_DISC_RAIN, "Dropped by a Drowned if killed by a Skeleton.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.MUSIC_DISC_SNOW, "Dropped by a Chilled if killed by a Skeleton.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.MUSIC_DISC_BUMBLEBEE, "Sometimes dropped when shearing a Beehive for Honeycombs.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.WILD_BERRIES, "Wild berries are the fruit of the wild berry bush. The plant is made unique by their ability to grow in snowy conditions. The berry can be cultivated for a juice that can regenerate health, and can be frozen to a popsicle that grants resistance to frost.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptBlocks.NIGHTSHADE, "Nightshades are mystical flowers found rarely growing in patches from the roots of trees. The flower emits a subtle white light.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptBlocks.CARVED_PINECONE_BLOCK, "The face of the Carved Pinecone creates a single note randomly as wind passes through them, the note produced is deeper depending on how high they are stacked on top of pinecone blocks. \n(Is activated through random tick, right clicking, or redstone)");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptBlocks.WILL_O_THE_WISP, "Will watch you when your back is turned.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptBlocks.ICE_LANTERN, "The Ice Lantern emits a light incapable of melting Ice and Snow.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.WOODEN_BUCKET, "Wooden buckets are easily craft-able; but it comes at a cost to their strength. Durability is taken when fluids exit the bucket.");
        this.jeiInfo((Supplier<? extends ItemLike>)WindsweptItems.SNOW_BOOTS, "Snow boots allow for faster traversal through snow, and grants the wearer the ability to walk on Powder Snow. The leather can be dyed.");
        this.translateRegistry(ForgeRegistries.BLOCKS, Block::m_7705_);
        this.translateRegistry(ForgeRegistries.ITEMS, Item::m_5524_);
        this.translateRegistry(ForgeRegistries.ENTITY_TYPES, EntityType::m_20675_);
    }

    private <T> void translateRegistry(IForgeRegistry<T> registry, Function<T, String> toString) {
        for (RegistryObject object : Windswept.REGISTRY_HELPER.getSubHelper(registry).getDeferredRegister().getEntries()) {
            this.add(toString.apply(object.get()), WindsweptLangProvider.toUpper(registry, object));
        }
    }

    public void add(String key, String value) {
        if (!this.keys.contains(key)) {
            super.add(key, value);
            this.keys.add(key);
        }
    }

    private void translateBlock(RegistryObject<? extends Block> block) {
        this.add((Block)block.get(), WindsweptLangProvider.toUpper(ForgeRegistries.BLOCKS, block));
    }

    private void translateEnchantment(RegistryObject<? extends Enchantment> enchantment, String name, String desc) {
        String descId = ((Enchantment)enchantment.get()).m_44704_();
        this.add(descId, name);
        this.add(descId + ".desc", desc);
    }

    private void translateBiome(ResourceKey<Biome> biome) {
        String name = biome.m_135782_().m_135815_();
        this.add("biome.windswept." + name, WindsweptLangProvider.toUpper(name));
    }

    private void translateTrimMaterial(ResourceKey<TrimMaterial> material, String name) {
        this.add("trim_material." + material.m_135782_().toString().replace(':', '.'), name);
    }

    private void translatePainting(RegistryObject<PaintingVariant> painting, String author) {
        String name = ForgeRegistries.PAINTING_VARIANTS.getKey((Object)((PaintingVariant)painting.get())).m_135815_();
        this.add("painting.windswept." + name + ".title", WindsweptLangProvider.toUpper(name));
        this.add("painting.windswept." + name + ".author", author);
    }

    private void translateMusicDisc(RegistryObject<? extends Item> item, String desc) {
        this.add((Item)item.get(), "Music Disc");
        this.addDescription(item, desc);
    }

    private void translateSign(Pair<RegistryObject<BlueprintStandingSignBlock>, RegistryObject<BlueprintWallSignBlock>> sign, String name) {
        this.translateBlock((RegistryObject<? extends Block>)((RegistryObject)sign.getFirst()));
        this.add(((BlueprintStandingSignBlock)((RegistryObject)sign.getFirst()).get()).m_7705_().replace(name, name + "_wall"), WindsweptLangProvider.toUpper(ForgeRegistries.BLOCKS, (RegistryObject)sign.getSecond()));
    }

    private void translateAttribute(RegistryObject<? extends Attribute> attribute) {
        this.add(((Attribute)attribute.get()).m_22087_(), WindsweptLangProvider.toUpper(ForgeRegistries.ATTRIBUTES, attribute));
    }

    private void translateEffect(RegistryObject<? extends MobEffect> effect, String desc) {
        this.add((MobEffect)effect.get(), WindsweptLangProvider.toUpper(ForgeRegistries.MOB_EFFECTS, effect));
        this.add(((MobEffect)effect.get()).m_19481_() + ".description", desc);
    }

    private void translateBannerPattern(RegistryObject<? extends Item> item, String name) {
        String desc = WindsweptLangProvider.toUpper(name);
        this.add((Item)item.get(), "Banner Pattern");
        this.addDescription(item, desc);
        for (DyeColor dye : DyeColor.values()) {
            this.add("block.minecraft.banner.windswept." + name + "." + dye.m_41065_(), WindsweptLangProvider.toUpper(dye.m_41065_()) + " " + desc);
        }
    }

    private void jeiInfo(Supplier<? extends ItemLike> item, String desc) {
        this.add(WindsweptPlugin.getDesc(item), desc);
    }

    private void translateDamageType(ResourceKey<DamageType> source, Function<String, String> death, BiFunction<String, String, String> killed) {
        String msgId = source.m_135782_().m_135815_();
        this.add("death.attack." + msgId, death.apply("%1$s"));
        this.add("death.attack." + msgId + ".player", killed.apply("%1$s", "%2$s"));
    }

    private void translatePotion(RegistryObject<? extends Potion> potion, String effect) {
        String name = ForgeRegistries.POTIONS.getKey((Object)((Potion)potion.get())).m_135815_();
        this.add("item.minecraft.potion.effect." + name, "Potion of " + effect);
        this.add("item.minecraft.splash_potion.effect." + name, "Splash Potion of " + effect);
        this.add("item.minecraft.tipped_arrow.effect." + name, "Arrow of " + effect);
        this.add("item.minecraft.lingering_potion.effect." + name, "Lingering Potion of " + effect);
        this.add("item.caverns_and_chasms.tether_potion.effect." + name, "Tether Potion of " + effect);
    }

    private void addDescription(RegistryObject<? extends ItemLike> item, String desc) {
        this.add(((ItemLike)item.get()).m_5456_().m_5524_() + ".desc", desc);
    }

    private static <T> String toUpper(IForgeRegistry<T> registry, RegistryObject<? extends T> object) {
        return WindsweptLangProvider.toUpper(registry.getKey(object.get()).m_135815_());
    }

    private static String toUpper(String string) {
        return StringUtils.capitaliseAllWords((String)string.replace('_', ' '));
    }
}

