/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.common.block;

import com.rosemods.windswept.core.registry.datapack.WindsweptDamageTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class IciclesBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<IcicleStates> STATE = EnumProperty.m_61587_((String)"state", IcicleStates.class);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)4.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape TOP = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape BOTTOM = Block.m_49796_((double)5.0, (double)6.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FLOOR = Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)4.5, (double)14.0);

    public IciclesBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STATE, (Comparable)((Object)IcicleStates.NORMAL))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        BlockState above;
        Direction direction = state.m_61143_(STATE) == IcicleStates.FLOOR ? Direction.UP : Direction.DOWN;
        BlockPos blockpos = pos.m_121945_(direction.m_122424_());
        if (direction == Direction.DOWN && (above = level.m_8055_(pos.m_7494_())).m_60713_((Block)this) && above.m_61143_(STATE) == IcicleStates.NORMAL) {
            return true;
        }
        return Block.m_49863_((LevelReader)level, (BlockPos)blockpos, (Direction)direction) || level.m_8055_(blockpos).m_204336_(BlockTags.f_13035_);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        BlockState blockState = state;
        BlockState below = level.m_8055_(currentPos.m_7495_());
        if (below.m_60713_((Block)this) && below.m_61143_(STATE) != IcicleStates.FLOOR) {
            blockState = (BlockState)blockState.m_61124_(STATE, (Comparable)((Object)IcicleStates.TOP));
        } else if (state.m_61143_(STATE) == IcicleStates.TOP && !below.m_60713_((Block)this)) {
            blockState = (BlockState)blockState.m_61124_(STATE, (Comparable)((Object)IcicleStates.NORMAL));
        }
        return blockState.m_60710_((LevelReader)level, currentPos) ? blockState : Blocks.f_50016_.m_49966_();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos blockpos, CollisionContext context) {
        return switch ((IcicleStates)((Object)state.m_61143_(STATE))) {
            default -> SHAPE;
            case IcicleStates.TOP -> TOP;
            case IcicleStates.BOTTOM -> BOTTOM;
            case IcicleStates.FLOOR -> FLOOR;
        };
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STATE, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : Fluids.f_76191_.m_76145_();
    }

    public void m_142072_(Level level, BlockState state, BlockPos pos, Entity entity, float damage) {
        if (state.m_61143_(STATE) == IcicleStates.FLOOR) {
            entity.m_142535_(damage + 2.0f, 2.0f, entity.m_269291_().m_269079_(WindsweptDamageTypes.ICICLE));
        } else {
            super.m_142072_(level, state, pos, entity, damage);
        }
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluid = level.m_6425_(pos);
        Direction face = context.m_43719_();
        if (face == Direction.DOWN) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)(level.m_8055_(pos.m_7494_()).m_60713_((Block)this) ? IcicleStates.BOTTOM : IcicleStates.NORMAL)));
            if (blockstate.m_60710_((LevelReader)level, pos)) {
                return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
            }
        } else if (face == Direction.UP) {
            BlockState blockstate = (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)IcicleStates.FLOOR));
            if (blockstate.m_60710_((LevelReader)level, pos)) {
                return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
            }
        } else {
            for (Direction direction : context.m_6232_()) {
                if (direction.m_122434_() != Direction.Axis.Y) continue;
                IcicleStates state = direction == Direction.UP ? IcicleStates.FLOOR : (level.m_8055_(pos.m_7494_()).m_60713_((Block)this) ? IcicleStates.BOTTOM : IcicleStates.NORMAL);
                BlockState blockstate = (BlockState)this.m_49966_().m_61124_(STATE, (Comparable)((Object)state));
                if (!blockstate.m_60710_((LevelReader)level, pos)) continue;
                return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluid.m_76152_() == Fluids.f_76193_));
            }
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        if (rand.m_188501_() < 0.05f && !((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue() && level.m_8055_(pos.m_7495_()).m_60795_()) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_175824_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.15, (double)pos.m_123343_() + 0.65, 0.0, 0.0, 0.0);
        }
    }

    public static enum IcicleStates implements StringRepresentable
    {
        NORMAL("normal"),
        TOP("top"),
        BOTTOM("bottom"),
        FLOOR("floor");

        private final String name;

        private IcicleStates(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

