/*
 * Decompiled with CFR 0.152.
 */
package com.rosemods.windswept.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.rosemods.windswept.common.entity.Frostbiter;
import com.rosemods.windswept.core.registry.WindsweptPlayableEndimations;
import com.teamabnormals.blueprint.core.endimator.Endimator;
import com.teamabnormals.blueprint.core.endimator.entity.EndimatorEntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class FrostbiterModel
extends EndimatorEntityModel<Frostbiter>
implements HeadedModel {
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart tail;
    private final ModelPart leftArm;
    private final ModelPart rightArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart front;
    private final ModelPart frontEyesClosed;
    private final ModelPart leaves;
    private final ModelPart leash;
    private final ModelPart bell;
    private final ModelPart saddle;
    private final ModelPart leftAntler;
    private final ModelPart rightAntler;
    private final ModelPart brokenLeftAntler;
    private final ModelPart brokenRightAntler;

    public FrostbiterModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = root.m_171324_("head");
        this.tail = root.m_171324_("tail");
        this.leftArm = root.m_171324_("left_arm");
        this.rightArm = root.m_171324_("right_arm");
        this.leftLeg = root.m_171324_("left_leg");
        this.rightLeg = root.m_171324_("right_leg");
        this.front = this.head.m_171324_("front");
        this.frontEyesClosed = this.head.m_171324_("front_eyes_closed");
        this.leaves = this.head.m_171324_("leaves");
        this.leash = this.head.m_171324_("leash");
        this.bell = this.leash.m_171324_("bell");
        this.saddle = this.body.m_171324_("saddle");
        this.leftAntler = this.head.m_171324_("left_antler");
        this.rightAntler = this.head.m_171324_("right_antler");
        this.brokenLeftAntler = this.head.m_171324_("broken_left_antler");
        this.brokenRightAntler = this.head.m_171324_("broken_right_antler");
        this.endimator = Endimator.compile((ModelPart)root);
    }

    public void setupAnim(Frostbiter frostbiter, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.m_6973_((Entity)frostbiter, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        boolean isShaking = frostbiter.isEndimationPlaying(WindsweptPlayableEndimations.FROSTBITER_SHAKE);
        boolean isEating = frostbiter.isEndimationPlaying(WindsweptPlayableEndimations.FROSTBITER_SHAKE);
        float smallLimbSwingAmount = Math.min(limbSwingAmount, 0.15f);
        float largeLimbSwingAmount = Math.min(limbSwingAmount, 0.5f);
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.9f * smallLimbSwingAmount;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.9f * smallLimbSwingAmount;
        this.leftLeg.f_104201_ = 2.0f + Mth.m_14031_((float)(limbSwing * 0.6662f)) * smallLimbSwingAmount * 2.0f;
        this.rightLeg.f_104201_ = 2.0f + Mth.m_14031_((float)(limbSwing * 0.6662f)) * smallLimbSwingAmount * 2.0f;
        if (!isEating) {
            float limbAngle = limbSwing * 0.5212f;
            float intensity = 0.1f;
            float yIntensity = 0.15f;
            this.rightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 0.5f * largeLimbSwingAmount;
            this.leftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.5f * largeLimbSwingAmount;
            this.rightArm.f_104201_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * smallLimbSwingAmount * 2.0f;
            this.leftArm.f_104201_ = Mth.m_14031_((float)(limbSwing * 0.6662f)) * smallLimbSwingAmount * 2.0f;
            this.rightArm.f_104205_ = 0.25f * smallLimbSwingAmount;
            this.leftArm.f_104205_ = -0.25f * smallLimbSwingAmount;
            if (frostbiter.m_217005_()) {
                this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
                this.head.f_104204_ = headPitch * ((float)Math.PI / 180);
                this.head.f_104201_ = 1.0f;
                this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.5212f + (float)Math.PI)) * limbSwingAmount * 0.25f;
                this.tail.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5212f + (float)Math.PI)) * 0.1f * limbSwingAmount * 0.25f;
            } else {
                this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.5212f + (float)Math.PI)) * largeLimbSwingAmount * 0.5f;
                this.tail.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.5212f + (float)Math.PI)) * 0.1f * largeLimbSwingAmount * 0.5f;
            }
            this.body.f_104205_ = Mth.m_14089_((float)limbAngle) * intensity * limbSwingAmount;
            this.body.f_104201_ -= 1.0f * Mth.m_14089_((float)(limbSwing * 1.5f / 2.0f)) * 2.0f * limbSwingAmount * yIntensity;
            this.head.f_104201_ -= 1.0f * Mth.m_14089_((float)(limbSwing * 1.5f / 2.0f)) * 2.0f * limbSwingAmount * yIntensity;
            if (!isShaking) {
                this.head.f_104204_ = headPitch * ((float)Math.PI / 180);
                this.bell.f_104205_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.3f * limbSwingAmount;
            }
        }
        this.front.f_104207_ = frostbiter.isNoEndimationPlaying();
        this.frontEyesClosed.f_104207_ = !this.front.f_104207_;
        this.leaves.f_104207_ = frostbiter.hasAntlers();
        this.leash.f_104207_ = frostbiter.m_21824_();
        this.saddle.f_104207_ = frostbiter.m_6254_();
        this.leftAntler.f_104207_ = frostbiter.hasLeftAntler();
        this.rightAntler.f_104207_ = frostbiter.hasRightAntler();
        this.brokenLeftAntler.f_104207_ = !this.leftAntler.f_104207_;
        this.brokenRightAntler.f_104207_ = !this.rightAntler.f_104207_;
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        if (this.f_102610_) {
            poseStack.m_85836_();
            poseStack.m_85841_(0.55f, 0.55f, 0.55f);
            poseStack.m_252880_(0.0f, 1.3f, 0.2f);
            this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
            poseStack.m_85836_();
            poseStack.m_85841_(0.45f, 0.45f, 0.45f);
            poseStack.m_252880_(0.0f, 1.5f, 0.0f);
            this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            poseStack.m_85849_();
        } else {
            this.head.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.tail.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightArm.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.leftLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
            this.rightLeg.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
        }
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

