/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.registry;

import dev.architectury.registry.client.level.entity.EntityModelLayerRegistry;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import satisfy.beachparty.client.BeachPartyClient;
import satisfy.beachparty.client.model.BeachHatModel;
import satisfy.beachparty.client.model.RubberRingAxolotlModel;
import satisfy.beachparty.client.model.RubberRingModel;
import satisfy.beachparty.client.model.RubberRingPelicanModel;
import satisfy.beachparty.config.BeachpartyConfig;
import satisfy.beachparty.item.IBeachpartyArmorSet;
import satisfy.beachparty.registry.ObjectRegistry;

public class ArmorRegistry {
    public static void registerCustomArmorLayers() {
        EntityModelLayerRegistry.register((ModelLayerLocation)BeachHatModel.LAYER_LOCATION, BeachHatModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)RubberRingPelicanModel.LAYER_LOCATION, RubberRingPelicanModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)RubberRingAxolotlModel.LAYER_LOCATION, RubberRingAxolotlModel::getTexturedModelData);
        EntityModelLayerRegistry.register((ModelLayerLocation)RubberRingModel.LAYER_LOCATION, RubberRingModel::getTexturedModelData);
    }

    public static <T extends LivingEntity> void registerHatModels(Map<Item, EntityModel<T>> models, EntityModelSet modelLoader) {
        models.put((Item)ObjectRegistry.BEACH_HAT.get(), new BeachHatModel(modelLoader.m_171103_(BeachHatModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.RUBBER_RING_PELICAN.get(), new RubberRingPelicanModel(modelLoader.m_171103_(RubberRingPelicanModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.RUBBER_RING_AXOLOTL.get(), new RubberRingAxolotlModel(modelLoader.m_171103_(RubberRingAxolotlModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.RUBBER_RING_BLUE.get(), new RubberRingModel(modelLoader.m_171103_(RubberRingModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.RUBBER_RING_PINK.get(), new RubberRingModel(modelLoader.m_171103_(RubberRingModel.LAYER_LOCATION)));
        models.put((Item)ObjectRegistry.RUBBER_RING_STRIPPED.get(), new RubberRingModel(modelLoader.m_171103_(RubberRingModel.LAYER_LOCATION)));
    }

    public static void appendTooltip(List<Component> tooltip) {
        BeachpartyConfig config = BeachpartyConfig.getActiveInstance();
        if (!config.enableBeachSetBonus()) {
            return;
        }
        Player player = BeachPartyClient.getClientPlayer();
        if (player == null) {
            return;
        }
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.swimwearline1").m_130940_(ChatFormatting.DARK_PURPLE));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.swimwearline2").m_130940_(ChatFormatting.BLUE));
        boolean helmet = IBeachpartyArmorSet.hasSwimearHelmet(player);
        boolean breastplate = IBeachpartyArmorSet.hasSwimwearBreastplate(player);
        boolean leggings = IBeachpartyArmorSet.hasSwimearLeggings(player);
        boolean boots = IBeachpartyArmorSet.hasSwimearBoots(player);
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.swimwear_set").m_130940_(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)(helmet ? Component.m_237115_((String)"tooltip.beachparty.swimwearhelmet").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.beachparty.swimwearhelmet").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(breastplate ? Component.m_237115_((String)"tooltip.beachparty.swimwearbreastplate").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.beachparty.swimwearbreastplate").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(leggings ? Component.m_237115_((String)"tooltip.beachparty.swimwearleggings").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.beachparty.swimwearleggings").m_130940_(ChatFormatting.GRAY)));
        tooltip.add((Component)(boots ? Component.m_237115_((String)"tooltip.beachparty.swimwearboots").m_130940_(ChatFormatting.GREEN) : Component.m_237115_((String)"tooltip.beachparty.swimwearboots").m_130940_(ChatFormatting.GRAY)));
        tooltip.add(Component.m_130674_((String)""));
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.swimwear_seteffect").m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)(helmet && breastplate && leggings && boots ? Component.m_237115_((String)"tooltip.beachparty.swimwear_effect").m_130940_(ChatFormatting.DARK_GREEN) : Component.m_237115_((String)"tooltip.beachparty.swimwear_effect").m_130940_(ChatFormatting.GRAY)));
    }
}

