/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.item;

import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.beachparty.registry.ObjectRegistry;

public class SandBucketItem
extends BlockItem {
    public SandBucketItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext context) {
        if (Objects.requireNonNull(context.m_43723_()).m_6144_()) {
            InteractionResult actionResult = this.m_40576_(new BlockPlaceContext(context));
            if (!actionResult.m_19077_() && this.m_41472_()) {
                InteractionResult actionResult2 = this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
                return actionResult2 == InteractionResult.CONSUME ? InteractionResult.CONSUME_PARTIAL : actionResult2;
            }
            return actionResult;
        }
        return this.m_7203_(context.m_43725_(), context.m_43723_(), context.m_43724_()).m_19089_();
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        BlockHitResult blockHitResult = SandBucketItem.m_41435_((Level)world, (Player)user, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        if (blockHitResult.m_6662_() == HitResult.Type.MISS) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        if (blockHitResult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemStack);
        }
        BlockPos blockPos = blockHitResult.m_82425_();
        Direction direction = blockHitResult.m_82434_();
        BlockPos offsetPos = blockPos.m_121945_(direction);
        if (world.m_7966_(user, blockPos)) {
            if (this == ObjectRegistry.EMPTY_SAND_BUCKET.get() && world.m_8055_(blockPos).m_204336_(BlockTags.f_13029_)) {
                world.m_46961_(blockPos, false);
                ItemStack sandBucket = new ItemStack((ItemLike)ObjectRegistry.SAND_BUCKET.get());
                ItemStack returnStack = this.exchangeStack(itemStack, user, sandBucket);
                return InteractionResultHolder.m_19092_((Object)returnStack, (boolean)world.m_5776_());
            }
            if (this == ObjectRegistry.SAND_BUCKET.get() && user.m_36204_(offsetPos, direction, itemStack) && world.m_8055_(offsetPos).m_60795_() && ((Block)ObjectRegistry.SANDCASTLE.get()).m_49966_().m_60710_((LevelReader)world, offsetPos)) {
                world.m_7731_(offsetPos, ((Block)ObjectRegistry.SANDCASTLE.get()).m_49966_(), 3);
                ItemStack returnStack = this.exchangeStack(itemStack, user, SandBucketItem.getEmptiedStack(itemStack, user));
                return InteractionResultHolder.m_19092_((Object)returnStack, (boolean)world.m_5776_());
            }
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    private ItemStack exchangeStack(ItemStack handStack, Player player, ItemStack possibleReturnStack) {
        ItemStack returnStack;
        ItemStack itemStack = returnStack = !player.m_150110_().f_35937_ ? possibleReturnStack : handStack;
        if (player.m_7500_()) {
            if (!player.m_150109_().m_36063_(possibleReturnStack)) {
                player.m_150109_().m_36054_(possibleReturnStack);
            }
            return handStack;
        }
        Inventory inventory = player.m_150109_();
        int slot = inventory.m_36030_(handStack);
        handStack.m_41774_(1);
        if (player.m_150109_().m_8020_(slot).m_41619_()) {
            if (!inventory.m_36040_(slot, returnStack)) {
                player.m_36176_(returnStack, false);
            }
        } else if (!inventory.m_36054_(returnStack)) {
            player.m_36176_(returnStack, false);
        }
        return possibleReturnStack;
    }

    public static ItemStack getEmptiedStack(ItemStack stack, Player player) {
        return !player.m_150110_().f_35937_ ? new ItemStack((ItemLike)ObjectRegistry.EMPTY_SAND_BUCKET.get()) : stack;
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, TooltipFlag context) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.beachparty.canbeplaced").m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
    }
}

