/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.client.gui;

import de.cristelknight.doapi.DoApiRL;
import de.cristelknight.doapi.config.cloth.CCUtil;
import de.cristelknight.doapi.config.cloth.LinkEntry;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.IntegerListEntry;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.builders.SubCategoryBuilder;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import satisfy.beachparty.config.BeachpartyConfig;

public class ClothConfigScreen {
    private static Screen lastScreen;

    public static Screen create(Screen parent) {
        lastScreen = parent;
        BeachpartyConfig config = (BeachpartyConfig)BeachpartyConfig.getActiveInstance().getConfig();
        ConfigBuilder builder = ConfigBuilder.create().setParentScreen(parent).setDefaultBackgroundTexture(new ResourceLocation("textures/block/sand.png")).setTitle((Component)Component.m_237115_((String)"beachparty.config.title").m_130940_(ChatFormatting.BOLD));
        ConfigEntries entries = new ConfigEntries(builder.entryBuilder(), config, builder.getOrCreateCategory(CCUtil.categoryName((String)"main", (String)"beachparty")));
        builder.setSavingRunnable(() -> {
            BeachpartyConfig.getActiveInstance().setInstance(entries.createConfig());
            BeachpartyConfig.getActiveInstance().getConfig(true, true);
        });
        return builder.build();
    }

    public static void linkButtons(String MOD_ID, ConfigCategory category, ConfigEntryBuilder builder, String dcLink, String cfLink, Screen lastScreen) {
        if (lastScreen == null) {
            lastScreen = Minecraft.m_91087_().f_91080_;
        }
        TextListEntry tle = builder.startTextDescription((Component)Component.m_237113_((String)" ")).build();
        category.addEntry((AbstractConfigListEntry)tle);
        Screen finalLastScreen = lastScreen;
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)MOD_ID, (String)"dc"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(dcLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, dcLink, true)), (ResourceLocation)new DoApiRL("textures/gui/dc.png"), 3));
        category.addEntry((AbstractConfigListEntry)tle);
        category.addEntry((AbstractConfigListEntry)new LinkEntry(CCUtil.entryName((String)MOD_ID, (String)"h"), buttonWidget -> Minecraft.m_91087_().m_91152_((Screen)new ConfirmLinkScreen(confirmed -> {
            if (confirmed) {
                Util.m_137581_().m_137646_(cfLink);
            }
            Minecraft.m_91087_().m_91152_(ClothConfigScreen.create(finalLastScreen));
        }, cfLink, true)), (ResourceLocation)new DoApiRL("textures/gui/cf.png"), 10));
    }

    private static class ConfigEntries {
        private final ConfigEntryBuilder builder;
        private final ConfigCategory category;
        private final BooleanListEntry enableBeachSetBonus;

        public ConfigEntries(ConfigEntryBuilder builder, BeachpartyConfig config, ConfigCategory category) {
            this.builder = builder;
            this.category = category;
            SubCategoryBuilder Beach = new SubCategoryBuilder((Component)Component.m_237119_(), (Component)Component.m_237115_((String)"config.beachparty.subCategory.beach"));
            this.enableBeachSetBonus = this.createBooleanField("enableBeachSetBonus", config.enableBeachSetBonus(), "Whether the beach armor should give a set bonus", Beach);
            category.addEntry((AbstractConfigListEntry)Beach.build());
            ClothConfigScreen.linkButtons("beachparty", category, builder, "https://discord.gg/Vqu6wYZwdZ", "https://www.curseforge.com/minecraft/mc-mods/lets-do-beachparty", lastScreen);
        }

        public BeachpartyConfig createConfig() {
            return new BeachpartyConfig(this.enableBeachSetBonus.getValue());
        }

        private BooleanListEntry createBooleanField(String key, boolean value, String tooltip, SubCategoryBuilder subCategoryBuilder) {
            BooleanListEntry entry = this.builder.startBooleanToggle((Component)Component.m_237115_((String)("beachparty.config." + key)), value).setDefaultValue(() -> true).setTooltip(new Component[]{Component.m_237113_((String)tooltip)}).build();
            subCategoryBuilder.add((AbstractConfigListEntry)entry);
            return entry;
        }

        public IntegerListEntry createIntField(String id, int value, int defaultValue, SubCategoryBuilder subCategoryBuilder, int min, int max) {
            IntegerListEntry e = CCUtil.createIntField((String)"beachparty", (String)id, (int)value, (int)defaultValue, (ConfigEntryBuilder)this.builder).setMaximum(max).setMinimum(min);
            if (subCategoryBuilder == null) {
                this.category.addEntry((AbstractConfigListEntry)e);
            } else {
                subCategoryBuilder.add((AbstractConfigListEntry)e);
            }
            return e;
        }
    }
}

