/*
 * Decompiled with CFR 0.152.
 */
package satisfy.beachparty.block;

import de.cristelknight.doapi.common.util.GeneralUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import satisfy.beachparty.util.HammockPart;

public class HammockBlock
extends HorizontalDirectionalBlock {
    public static final EnumProperty<HammockPart> PART;
    public static final BooleanProperty OCCUPIED;
    private static final Supplier<VoxelShape> leftShapeSupplier;
    public static final Map<Direction, VoxelShape> LEFT_SHAPE;
    private static final Supplier<VoxelShape> middleShapeSupplier;
    public static final Map<Direction, VoxelShape> MIDDLE_SHAPE;
    private static final Supplier<VoxelShape> rightShapeSupplier;
    public static final Map<Direction, VoxelShape> RIGHT_SHAPE;

    public HammockBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_(PART, (Comparable)((Object)HammockPart.MIDDLE))).m_61124_((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        return state.m_61143_(PART) == HammockPart.LEFT ? LEFT_SHAPE.get(direction) : (state.m_61143_(PART) == HammockPart.RIGHT ? RIGHT_SHAPE.get(direction) : MIDDLE_SHAPE.get(direction));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Direction direction = ctx.m_8125_().m_122424_();
        BlockPos middle = ctx.m_8083_();
        BlockPos left = middle.m_121945_(direction.m_175364_(Direction.Axis.Y));
        BlockPos right = middle.m_121945_(direction.m_175362_(Direction.Axis.Y));
        Level world = ctx.m_43725_();
        return world.m_8055_(left).m_60629_(ctx) && world.m_6857_().m_61937_(left) && world.m_8055_(right).m_60629_(ctx) && world.m_6857_().m_61937_(right) ? (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)direction) : null;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack itemStack) {
        super.m_6402_(world, pos, state, placer, itemStack);
        if (!world.f_46443_) {
            BlockPos left = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_175362_(Direction.Axis.Y));
            BlockPos right = pos.m_121945_(((Direction)state.m_61143_((Property)f_54117_)).m_175364_(Direction.Axis.Y));
            world.m_7731_(left, (BlockState)state.m_61124_(PART, (Comparable)((Object)HammockPart.LEFT)), 3);
            world.m_7731_(right, (BlockState)state.m_61124_(PART, (Comparable)((Object)HammockPart.RIGHT)), 3);
            world.m_6289_(pos, Blocks.f_50016_);
            state.m_60701_((LevelAccessor)world, pos, 3);
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        HammockPart part = (HammockPart)((Object)state.m_61143_(PART));
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (part) {
            case MIDDLE: {
                BlockPos left = pos.m_121945_(direction.m_175362_(Direction.Axis.Y));
                BlockPos right = pos.m_121945_(direction.m_175364_(Direction.Axis.Y));
                if (world.m_8055_(left).m_60734_() == this) {
                    world.m_7731_(left, Blocks.f_50016_.m_49966_(), 35);
                }
                if (world.m_8055_(right).m_60734_() != this) break;
                world.m_7731_(right, Blocks.f_50016_.m_49966_(), 35);
                break;
            }
            case LEFT: {
                BlockPos middle = pos.m_121945_(direction.m_175364_(Direction.Axis.Y));
                BlockPos right = pos.m_121945_(direction.m_175364_(Direction.Axis.Y)).m_121945_(direction.m_175364_(Direction.Axis.Y));
                if (world.m_8055_(middle).m_60734_() == this) {
                    world.m_7731_(middle, Blocks.f_50016_.m_49966_(), 35);
                }
                if (world.m_8055_(right).m_60734_() != this) break;
                world.m_7731_(right, Blocks.f_50016_.m_49966_(), 35);
                break;
            }
            case RIGHT: {
                BlockPos middle = pos.m_121945_(direction.m_175362_(Direction.Axis.Y));
                BlockPos left = pos.m_121945_(direction.m_175362_(Direction.Axis.Y)).m_121945_(direction.m_175362_(Direction.Axis.Y));
                if (world.m_8055_(middle).m_60734_() == this) {
                    world.m_7731_(middle, Blocks.f_50016_.m_49966_(), 35);
                }
                if (world.m_8055_(left).m_60734_() != this) break;
                world.m_7731_(left, Blocks.f_50016_.m_49966_(), 35);
            }
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    private boolean isHammockWhole(BlockState state, Level world, BlockPos pos) {
        HammockPart part = (HammockPart)((Object)state.m_61143_(PART));
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch (part) {
            case MIDDLE: {
                BlockPos left = pos.m_121945_(direction.m_175362_(Direction.Axis.Y));
                BlockPos right = pos.m_121945_(direction.m_175364_(Direction.Axis.Y));
                return world.m_8055_(left).m_60734_() == this && world.m_8055_(right).m_60734_() == this;
            }
            case LEFT: {
                BlockPos middle = pos.m_121945_(direction.m_175364_(Direction.Axis.Y));
                BlockPos right = pos.m_121945_(direction.m_175364_(Direction.Axis.Y)).m_121945_(direction.m_175364_(Direction.Axis.Y));
                return world.m_8055_(middle).m_60734_() == this && world.m_8055_(right).m_60734_() == this;
            }
            case RIGHT: {
                BlockPos middle = pos.m_121945_(direction.m_175362_(Direction.Axis.Y));
                BlockPos left = pos.m_121945_(direction.m_175362_(Direction.Axis.Y)).m_121945_(direction.m_175362_(Direction.Axis.Y));
                return world.m_8055_(middle).m_60734_() == this && world.m_8055_(left).m_60734_() == this;
            }
        }
        return false;
    }

    public static boolean isBedWorking(Level world) {
        return world.m_6042_().f_63862_();
    }

    public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_46961_(pos, true);
        }
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (!state.m_60710_((LevelReader)world, pos)) {
            world.m_186460_(pos, (Block)this, 1);
        }
        return super.m_7417_(state, direction, neighborState, world, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.m_7495_();
        return world.m_8055_(blockPos).m_60783_((BlockGetter)world, blockPos, Direction.UP);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
        return false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, PART, OCCUPIED});
    }

    static {
        leftShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)-0.1875, (double)0.62, (double)0.125, (double)0.07499999999999996, (double)0.6825, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)0.0, (double)0.4375, (double)0.8125, (double)1.0, (double)0.5625));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.6875, (double)1.0, (double)0.4375, (double)0.8125, (double)1.3125, (double)0.5625));
            return shape;
        };
        LEFT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)leftShapeSupplier.get()));
            }
        });
        middleShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.62, (double)0.125, (double)0.8125, (double)0.6825, (double)1.0));
            return shape;
        };
        MIDDLE_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)middleShapeSupplier.get()));
            }
        });
        rightShapeSupplier = () -> {
            VoxelShape shape = Shapes.m_83040_();
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.925, (double)0.62, (double)0.125, (double)1.1875, (double)0.6825, (double)1.0));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)0.0, (double)0.4375, (double)0.3125, (double)1.0, (double)0.5625));
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83048_((double)0.1875, (double)1.0, (double)0.4375, (double)0.3125, (double)1.3125, (double)0.5625));
            return shape;
        };
        RIGHT_SHAPE = (Map)Util.m_137469_(new HashMap(), map -> {
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                map.put(direction, GeneralUtil.rotateShape((Direction)Direction.NORTH, (Direction)direction, (VoxelShape)rightShapeSupplier.get()));
            }
        });
        PART = EnumProperty.m_61587_((String)"part", HammockPart.class);
        OCCUPIED = BlockStateProperties.f_61445_;
    }
}

