/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.Collections;
import java.util.Iterator;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={BezierConnection.SegmentAngles.class})
public class MixinSegmentAngles {
    @Shadow(remap=false)
    @Final
    public int length;
    @Shadow
    @Final
    @NotNull
    public BlockPos[] lightPosition;
    @Shadow(remap=false)
    @Final
    @NotNull
    public Couple<PoseStack.Pose>[] railTransforms;
    @Shadow
    @Final
    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull PoseStack.Pose[] tieTransform;

    @ModifyExpressionValue(method={"<init>"}, at={@At(value="CONSTANT", args={"doubleValue=0.9649999737739563"})}, remap=false)
    private static double railways$modifyRailWidth(double original, @Local(argsOnly=true) BezierConnection bc) {
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
            return original + 0.5;
        }
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
            return original - 0.4375;
        }
        return original;
    }

    @WrapOperation(method={"<init>"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/track/BezierConnection;iterator()Ljava/util/Iterator;")}, remap=false)
    private Iterator<BezierConnection.Segment> makeMonorailSegments(BezierConnection bc, Operation<Iterator<BezierConnection.Segment>> original) {
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            int segmentCount = this.length - 1;
            Couple previousOffsets = null;
            for (BezierConnection.Segment segment : bc) {
                int i = segment.index;
                boolean end = i == 0 || i == segmentCount;
                Vec3 mainGirder = segment.position;
                Vec3 upNormal = segment.derivative.m_82541_().m_82537_(segment.normal);
                Vec3 firstGirderOffset = upNormal.m_82490_(0.5);
                Vec3 secondGirderOffset = upNormal.m_82490_(-0.625);
                Vec3 mainTop = segment.position.m_82549_(firstGirderOffset);
                Vec3 mainBottom = mainTop.m_82549_(secondGirderOffset);
                Couple offsets = Couple.create((Object)mainTop, (Object)mainBottom);
                if (previousOffsets == null) {
                    previousOffsets = offsets;
                    continue;
                }
                this.lightPosition[i] = BlockPos.m_274446_((Position)mainGirder);
                this.railTransforms[i] = Couple.create(null, null);
                float scale = end ? 2.3f : 2.2f;
                Vec3 currentBeam = ((Vec3)offsets.getFirst()).m_82549_((Vec3)offsets.getSecond()).m_82490_(0.5);
                Vec3 previousBeam = ((Vec3)previousOffsets.getFirst()).m_82549_((Vec3)previousOffsets.getSecond()).m_82490_(0.5);
                Vec3 beamDiff = currentBeam.m_82546_(previousBeam);
                Vec3 beamAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)beamDiff);
                PoseStack poseStack = new PoseStack();
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)poseStack).translate(previousBeam)).rotateY((float)beamAngles.f_82480_)).rotateX((float)beamAngles.f_82479_)).rotateZ((float)beamAngles.f_82481_)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f);
                this.tieTransform[i] = poseStack.m_85850_();
                for (boolean top : Iterate.trueAndFalse) {
                    Vec3 current = (Vec3)offsets.get(top);
                    Vec3 previous = (Vec3)previousOffsets.get(top);
                    Vec3 diff = current.m_82546_(previous);
                    Vec3 capAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)diff);
                    poseStack = new PoseStack();
                    ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)poseStack).translate(previous)).rotateY((float)capAngles.f_82480_)).rotateX((float)capAngles.f_82479_)).rotateZ((float)capAngles.f_82481_)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).rotateZ(0.0f)).scale(1.0f, 1.0f, (float)diff.m_82553_() * scale);
                    this.railTransforms[i].set(top, (Object)poseStack.m_85850_());
                }
                previousOffsets = offsets;
            }
            return Collections.emptyIterator();
        }
        return (Iterator)original.call(new Object[]{bc});
    }
}

