/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.forge;

import com.mojang.brigadier.CommandDispatcher;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.config.forge.CRConfigsImpl;
import com.railwayteam.railways.content.fuel.tank.FuelTankBlock;
import com.railwayteam.railways.forge.RailwaysClientImpl;
import com.railwayteam.railways.multiloader.Env;
import com.railwayteam.railways.registry.forge.CRBlockEntitiesImpl;
import com.railwayteam.railways.registry.forge.CRBlocksImpl;
import com.railwayteam.railways.registry.forge.CRCreativeModeTabsImpl;
import com.railwayteam.railways.registry.forge.CRMountedStorageTypesImpl;
import com.railwayteam.railways.registry.forge.CRParticleTypesParticleEntryImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.api.contraption.BlockMovementChecks;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="railways")
@Mod.EventBusSubscriber
public class RailwaysImpl {
    static IEventBus bus;
    private static final Set<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>> commandConsumers;

    public RailwaysImpl() {
        bus = FMLJavaModLoadingContext.get().getModEventBus();
        CRCreativeModeTabsImpl.register(bus);
        Railways.init();
        CRConfigsImpl.register(ModLoadingContext.get());
        CRParticleTypesParticleEntryImpl.register(bus);
        Env.CLIENT.runIfCurrent(() -> () -> RailwaysClientImpl.init());
    }

    public static void finalizeRegistrate() {
        Railways.registrate().registerEventListeners(bus);
    }

    public static void registerCommands(BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean> consumer) {
        commandConsumers.add(consumer);
    }

    @SubscribeEvent
    public static void onCommandRegistration(RegisterCommandsEvent event) {
        Commands.CommandSelection selection = event.getCommandSelection();
        boolean dedicated = selection == Commands.CommandSelection.ALL || selection == Commands.CommandSelection.DEDICATED;
        commandConsumers.forEach(consumer -> consumer.accept(event.getDispatcher(), dedicated));
    }

    public static void platformBasedRegistration() {
        BlockMovementChecks.registerAttachedCheck((state, world, pos, direction) -> {
            if (state.m_60734_() instanceof FuelTankBlock && ConnectivityHandler.isConnected((BlockGetter)world, (BlockPos)pos, (BlockPos)pos.m_121945_(direction))) {
                return BlockMovementChecks.CheckResult.SUCCESS;
            }
            return BlockMovementChecks.CheckResult.PASS;
        });
        CRMountedStorageTypesImpl.init();
        CRBlocksImpl.init();
        CRBlockEntitiesImpl.init();
    }

    static {
        commandConsumers = new HashSet<BiConsumer<CommandDispatcher<CommandSourceStack>, Boolean>>();
    }
}

