/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.swampy;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;

public class Swampy
extends Zombie {
    public Swampy(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 4;
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21345_.m_25352_(2, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22276_, 16.0).m_22268_(Attributes.f_22279_, 0.23).m_22268_(Attributes.f_22281_, 3.0);
    }

    public boolean m_7327_(Entity entity) {
        boolean hurt = super.m_7327_(entity);
        if (hurt && this.m_21205_().m_41619_() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            living.m_147207_(new MobEffectInstance(MobEffects.f_19610_, 140 * (int)modifier), (Entity)this);
            living.m_147207_(new MobEffectInstance(MobEffects.f_19614_, 140 * (int)modifier), (Entity)this);
        }
        if (hurt && this.m_6162_()) {
            this.m_6074_();
        }
        return hurt;
    }

    public void m_7023_(Vec3 travelVector) {
        if (this.m_21515_() && this.m_20072_()) {
            this.m_19920_(0.025f, travelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_((double)0.9f));
        } else {
            super.m_7023_(travelVector);
        }
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_6667_(DamageSource source) {
        super.m_6667_(source);
        if (!this.m_9236_().f_46443_ && (this.f_19796_.m_188501_() <= 0.8f || this.m_6162_())) {
            this.spawnLingeringCloud();
            if (this.m_6162_()) {
                this.m_9236_().m_7605_((Entity)this, (byte)14);
            }
        }
    }

    private void spawnLingeringCloud() {
        AreaEffectCloud cloud = new AreaEffectCloud(this.m_9236_(), this.m_20185_(), this.m_20186_(), this.m_20189_());
        cloud.m_19712_(2.5f);
        cloud.m_19732_(-0.5f);
        cloud.m_19740_(10);
        cloud.m_19734_(cloud.m_19748_() / 2);
        cloud.m_19738_(-cloud.m_19743_() / (float)cloud.m_19748_());
        cloud.m_19716_(new MobEffectInstance(MobEffects.f_19614_, 200));
        this.m_9236_().m_7967_((Entity)cloud);
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 14) {
            this.createPoisonExplosion();
        }
    }

    private void createPoisonExplosion() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        for (int i = 0; i < 10; ++i) {
            double motionX = this.f_19796_.m_188583_() * 0.2;
            double motionY = this.f_19796_.m_188583_() * 0.2;
            double motionZ = this.f_19796_.m_188583_() * 0.2;
            for (int j = 0; j < 20; ++j) {
                double xzAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
                double yAngle = this.f_19796_.m_188500_() * Math.PI / 2.0;
                double motionXDir = Math.cos(xzAngle) * Math.sin(yAngle);
                double motionYDir = Math.cos(yAngle);
                double motionZDir = Math.sin(xzAngle) * Math.sin(yAngle);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123765_, posX, posY, posZ, motionX + motionXDir * 0.1, motionY + motionYDir * 0.1, motionZ + motionZDir * 0.1);
            }
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_9236_().m_7106_((ParticleOptions)(this.f_19796_.m_188499_() ? new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50518_.m_49966_()) : new BlockParticleOption(ParticleTypes.f_123814_, Blocks.f_50519_.m_49966_())), this.m_20208_(0.5), this.m_20187_() - 0.5, this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public boolean m_7301_(MobEffectInstance instance) {
        return instance.m_19544_() != MobEffects.f_19614_ && super.m_7301_(instance);
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.SWAMPY_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.SWAMPY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.SWAMPY_DEATH.get();
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.SWAMPY_HEAD.get());
    }

    public static boolean checkSwampySpawnRules(EntityType<Swampy> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Swampy.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }
}

