/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.frostbitten;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.burned.Burned;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCMobEffects;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class Frostbitten
extends Zombie {
    private static final byte SNOW_EXPLOSION_ID = 14;

    public Frostbitten(EntityType<? extends Zombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 5;
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 3.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    protected void m_6878_() {
        super.m_6878_();
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Burned.class, true));
    }

    public boolean m_7327_(Entity entity) {
        LivingEntity living;
        boolean hurt = super.m_7327_(entity);
        if (hurt && this.m_21205_().m_41619_() && entity instanceof LivingEntity && (living = (LivingEntity)entity).m_142079_()) {
            float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
            living.m_147207_(new MobEffectInstance(RCMobEffects.FREEZE.get(), 140 * (int)modifier), (Entity)this);
        }
        return hurt;
    }

    protected void m_5806_(BlockPos pos) {
        super.m_5806_(pos);
        FrostWalkerEnchantment.m_45018_((LivingEntity)this, (Level)this.m_9236_(), (BlockPos)pos, (int)0);
    }

    public void m_6667_(DamageSource source) {
        if (this.m_6162_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)14);
            if (!this.m_9236_().f_46443_) {
                List entities = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(5.0), EntitySelector.f_20406_);
                for (LivingEntity entity : entities) {
                    if (!entity.m_142079_()) continue;
                    float modifier = this.m_9236_().m_6436_(this.m_20183_()).m_19056_();
                    entity.m_147207_(new MobEffectInstance(RCMobEffects.FREEZE.get(), 100 * (int)modifier), (Entity)this);
                }
            }
        }
        super.m_6667_(source);
    }

    public void m_7822_(byte id) {
        super.m_7822_(id);
        if (id == 14) {
            this.createSnowExplosion();
        }
    }

    private void createSnowExplosion() {
        double posX = this.m_20185_();
        double posY = this.m_20186_();
        double posZ = this.m_20189_();
        for (int i = 0; i < 100; ++i) {
            double motionX = this.f_19796_.m_188583_() * 0.2;
            double motionY = this.f_19796_.m_188583_() * 0.2;
            double motionZ = this.f_19796_.m_188583_() * 0.2;
            for (int j = 0; j < 20; ++j) {
                double xzAngle = this.f_19796_.m_188500_() * Math.PI * 2.0;
                double yAngle = this.f_19796_.m_188500_() * Math.PI / 2.0;
                double motionXDir = Math.cos(xzAngle) * Math.sin(yAngle);
                double motionYDir = Math.cos(yAngle);
                double motionZDir = Math.sin(xzAngle) * Math.sin(yAngle);
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_175821_, posX, posY, posZ, motionX + motionXDir * 0.1, motionY + motionYDir * 0.1, motionZ + motionZDir * 0.1);
            }
        }
    }

    public boolean m_7301_(MobEffectInstance instance) {
        return instance.m_19544_() != RCMobEffects.FREEZE.get() && super.m_7301_(instance);
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.FROSTBITTEN_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.FROSTBITTEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.FROSTBITTEN_DEATH.get();
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.FROSTBITTEN_HEAD.get());
    }

    public static boolean checkFrostbittenSpawnRules(EntityType<Frostbitten> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Frostbitten.m_219013_(type, (ServerLevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }
}

