/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.entities.living.deadbeard;

import com.github.teamfusion.rottencreatures.client.registries.RCSoundEvents;
import com.github.teamfusion.rottencreatures.common.level.entities.living.SpellcasterZombie;
import com.github.teamfusion.rottencreatures.common.level.entities.living.lackey.Lackey;
import com.github.teamfusion.rottencreatures.common.level.entities.living.lackey.SkeletonLackey;
import com.github.teamfusion.rottencreatures.common.level.entities.living.lackey.ZombieLackey;
import com.github.teamfusion.rottencreatures.common.registries.RCBlocks;
import com.github.teamfusion.rottencreatures.common.registries.RCEntityTypes;
import com.github.teamfusion.rottencreatures.core.data.loot.RCLootTables;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;

public class DeadBeard
extends SpellcasterZombie {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> DATA_IGNITED = SynchedEntityData.m_135353_(DeadBeard.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public DeadBeard(EntityType<? extends SpellcasterZombie> type, Level level) {
        super(type, level);
        this.f_21364_ = 20;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Zombie.m_34328_().m_22268_(Attributes.f_22287_, 0.0).m_22268_(Attributes.f_22276_, 70.0).m_22268_(Attributes.f_22279_, 0.275).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new SpellcasterZombie.CastingSpellGoal());
        this.f_21345_.m_25352_(4, (Goal)new SummonLackeysGoal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_FUSE_ID, (Object)100);
        this.m_20088_().m_135372_(DATA_IGNITED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128376_("Fuse", (short)this.getFuse());
        tag.m_128379_("IsIgnited", this.isIgnited());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setFuse(tag.m_128448_("Fuse"));
        this.setIgnited(tag.m_128471_("IsIgnited"));
    }

    public void setFuse(int ticks) {
        this.m_20088_().m_135381_(DATA_FUSE_ID, (Object)ticks);
    }

    public int getFuse() {
        return (Integer)this.m_20088_().m_135370_(DATA_FUSE_ID);
    }

    public void setIgnited(boolean ignited) {
        this.m_20088_().m_135381_(DATA_IGNITED, (Object)ignited);
    }

    public boolean isIgnited() {
        return (Boolean)this.m_20088_().m_135370_(DATA_IGNITED);
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        super.m_213945_(random, difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)Items.f_42425_));
    }

    protected boolean m_5884_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public void m_6863_(boolean baby) {
    }

    private void explode() {
        this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), 4.0f, Level.ExplosionInteraction.MOB);
    }

    protected void m_7472_(DamageSource source, int lootingMultiplier, boolean hitByPlayer) {
        super.m_7472_(source, lootingMultiplier, hitByPlayer);
        if (hitByPlayer) {
            if (this.isIgnited()) {
                this.m_19998_((ItemLike)RCBlocks.TNT_BARREL.get());
            }
            ItemStack chestStack = new ItemStack((ItemLike)RCBlocks.TREASURE_CHEST.get());
            CompoundTag blockEntityTag = new CompoundTag();
            blockEntityTag.m_128362_("Owner", this.m_20148_());
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel server = (ServerLevel)level;
                LootParams builder = this.createTreasureLootContext(source, lootingMultiplier, server);
                LootTable lootTable = server.m_7654_().m_278653_().m_278676_(RCLootTables.TREASURE_CHEST);
                ObjectArrayList lootItems = lootTable.m_287195_(builder);
                int targetMaxStackSize = lootItems.stream().filter(item -> !item.m_41619_()).findFirst().map(ItemStack::m_41741_).orElse(-1);
                if (targetMaxStackSize > 0) {
                    ListTag itemsList = new ListTag();
                    int totalCount = 0;
                    for (ItemStack item2 : lootItems) {
                        if (item2.m_41619_() || item2.m_41741_() != targetMaxStackSize) continue;
                        if (totalCount >= targetMaxStackSize) break;
                        int toAdd = Math.min(item2.m_41613_(), targetMaxStackSize - totalCount);
                        ItemStack stackToAdd = item2.m_41777_();
                        stackToAdd.m_41764_(toAdd);
                        CompoundTag itemTag = new CompoundTag();
                        stackToAdd.m_41739_(itemTag);
                        itemsList.add((Object)itemTag);
                        totalCount += toAdd;
                    }
                    blockEntityTag.m_128365_("Items", (Tag)itemsList);
                    blockEntityTag.m_128405_("ItemCount", totalCount);
                    blockEntityTag.m_128405_("MaxStackSize", targetMaxStackSize);
                }
            }
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("BlockEntityTag", (Tag)blockEntityTag);
            chestStack.m_41751_(nbt);
            this.m_19983_(chestStack);
        }
    }

    private LootParams createTreasureLootContext(DamageSource source, float lootingMultiplier, ServerLevel server) {
        LootParams.Builder builder = new LootParams.Builder(server).m_287286_(LootContextParams.f_81455_, (Object)this).m_287286_(LootContextParams.f_81460_, (Object)this.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)source).m_287289_(LootContextParams.f_81458_, (Object)source.m_7639_()).m_287289_(LootContextParams.f_81459_, (Object)source.m_7640_());
        if (this.f_20888_ != null) {
            builder.m_287286_(LootContextParams.f_81456_, (Object)this.f_20888_).m_287239_(this.f_20888_.m_36336_() + lootingMultiplier);
        }
        return builder.m_287235_(LootContextParamSets.f_81415_);
    }

    protected ItemStack m_5728_() {
        return new ItemStack((ItemLike)RCBlocks.DEAD_BEARD_HEAD.get());
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.isIgnited() && (double)this.m_21223_() <= 10.0 && !this.m_21224_()) {
            this.setIgnited(true);
            this.setFuse(100);
            this.m_9236_().m_5594_(null, this.m_20183_(), SoundEvents.f_12512_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (this.isIgnited() && !this.m_21224_()) {
            int cooldown = this.getFuse() - 1;
            this.setFuse(cooldown);
            if (cooldown <= 0) {
                this.m_146870_();
                this.explode();
            }
        }
    }

    public boolean m_6779_(LivingEntity entity) {
        return !this.isIgnited() && super.m_6779_(entity);
    }

    protected boolean m_7593_() {
        return false;
    }

    public static boolean checkDeadBeardSpawnRules(EntityType<DeadBeard> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return DeadBeard.m_219019_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random) && (spawnType == MobSpawnType.SPAWNER || level.m_45527_(pos));
    }

    protected SoundEvent m_7515_() {
        return RCSoundEvents.DEAD_BEARD_IDLE.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return RCSoundEvents.DEAD_BEARD_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return RCSoundEvents.DEAD_BEARD_DEATH.get();
    }

    class SummonLackeysGoal
    extends SpellcasterZombie.UseSpellGoal {
        private final TargetingConditions lackeyCountTargeting = TargetingConditions.m_148353_().m_26883_(16.0).m_148355_().m_26893_();

        SummonLackeysGoal() {
        }

        @Override
        public boolean m_8036_() {
            if (!super.m_8036_()) {
                return false;
            }
            int zombies = DeadBeard.this.m_9236_().m_45971_(ZombieLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.m_20191_().m_82400_(16.0)).size();
            int skeletons = DeadBeard.this.m_9236_().m_45971_(SkeletonLackey.class, this.lackeyCountTargeting, (LivingEntity)DeadBeard.this, DeadBeard.this.m_20191_().m_82400_(16.0)).size();
            return DeadBeard.this.f_19796_.m_188503_(4) + 1 > zombies + skeletons;
        }

        @Override
        protected void performSpellCasting() {
            ServerLevel server = (ServerLevel)DeadBeard.this.m_9236_();
            server.m_5594_(null, DeadBeard.this.m_20183_(), RCSoundEvents.DEAD_BEARD_CALL.get(), SoundSource.HOSTILE, 1.0f, 1.0f);
            for (int i = 0; i <= DeadBeard.this.f_19796_.m_188503_(4); ++i) {
                Monster lackey;
                BlockPos pos = DeadBeard.this.m_20183_().m_7918_(-2 + DeadBeard.this.f_19796_.m_188503_(5), -1, -2 + DeadBeard.this.f_19796_.m_188503_(5));
                Monster monster = lackey = DeadBeard.this.f_19796_.m_188499_() ? (Monster)RCEntityTypes.ZOMBIE_LACKEY.get().m_20615_((Level)server) : (Monster)RCEntityTypes.SKELETON_LACKEY.get().m_20615_((Level)server);
                if (!(lackey instanceof Lackey)) continue;
                Lackey lackeyIn = (Lackey)lackey;
                lackey.m_20035_(pos, 0.0f, 0.0f);
                lackey.m_20334_(0.0, 0.5, 0.0);
                server.m_5594_(null, lackey.m_20183_(), SoundEvents.f_11993_, SoundSource.NEUTRAL, 1.0f, 1.0f);
                lackey.m_6518_((ServerLevelAccessor)server, server.m_6436_(pos), MobSpawnType.MOB_SUMMONED, null, null);
                lackeyIn.setLimitedLife(500);
                server.m_7967_((Entity)lackey);
            }
            DeadBeard.this.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 100, 1));
        }

        @Override
        protected int getCastingTime() {
            return 100;
        }

        @Override
        protected int getCastingInterval() {
            return 340;
        }
    }
}

