/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blocks;

import com.github.teamfusion.rottencreatures.common.level.blockentities.TreasureChestBlockEntity;
import com.mojang.authlib.GameProfile;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TreasureChestBlock
extends BaseEntityBlock {
    private static final int MAX = 15;
    private static final int ROTATIONS = 16;
    public static final IntegerProperty ROTATION = BlockStateProperties.f_61390_;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    private static final VoxelShape SHAPE = TreasureChestBlock.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)7.0, (double)13.0);

    public TreasureChestBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (placer instanceof Player) {
            Player player = (Player)placer;
            if (blockEntity instanceof TreasureChestBlockEntity) {
                TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
                chest.setOwnerUUID(player.m_20148_());
                CompoundTag compoundTag = stack.m_41737_("BlockEntityTag");
                if (compoundTag != null && compoundTag.m_128441_("Item")) {
                    chest.m_142466_(compoundTag);
                }
            }
        }
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return TreasureChestBlock.m_49863_((LevelReader)level, (BlockPos)pos.m_7495_(), (Direction)Direction.UP);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.m_60710_((LevelReader)level, currentPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        if (!TreasureChestBlock.m_49863_((LevelReader)context.m_43725_(), (BlockPos)context.m_8083_().m_7495_(), (Direction)Direction.UP)) {
            return null;
        }
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(Mth.m_14107_((double)((double)(context.m_7074_() * 16.0f / 360.0f) + 0.5)) & 0xF))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof TreasureChestBlockEntity)) {
            return InteractionResult.PASS;
        }
        TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
        if (!chest.isOwner(player.m_20148_())) {
            UUID ownerUUID = chest.getOwnerUUID();
            if (ownerUUID != null && level.m_7654_() != null) {
                String ownerName = level.m_7654_().m_129927_().m_11002_(ownerUUID).map(GameProfile::getName).orElse("someone");
                player.m_5661_((Component)Component.m_237110_((String)"block.rottencreatures.treasure_chest.cannot_open", (Object[])new Object[]{Component.m_237113_((String)ownerName).m_130940_(ChatFormatting.GOLD)}), true);
            } else {
                player.m_5661_((Component)Component.m_237115_((String)"block.rottencreatures.treasure_chest.locked"), true);
            }
            return InteractionResult.PASS;
        }
        boolean isOpen = (Boolean)state.m_61143_((Property)OPEN);
        ItemStack heldItem = player.m_21120_(hand);
        if (!isOpen) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true)), 3);
            level.m_5594_(null, pos, SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            if (chest.hasContents()) {
                NonNullList<ItemStack> storedItems = chest.removeAllItems();
                for (ItemStack stack : storedItems) {
                    this.spawnItemEntity(level, pos, stack);
                }
            }
        } else {
            if (!heldItem.m_41619_()) {
                BlockItem block;
                Item item = heldItem.m_41720_();
                if (item instanceof BlockItem && !(block = (BlockItem)item).m_142095_()) {
                    return InteractionResult.PASS;
                }
                int amountToAdd = TreasureChestBlock.addItemsToContainer(chest, heldItem);
                NonNullList<ItemStack> replacedItems = chest.addItemsWithReplacement(heldItem.m_41777_(), amountToAdd);
                for (ItemStack replacedItem : replacedItems) {
                    this.spawnItemEntity(level, pos, replacedItem);
                }
                heldItem.m_41774_(amountToAdd);
                level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
                return InteractionResult.CONSUME;
            }
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false)), 3);
            level.m_5594_(null, pos, SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
        }
        player.m_36220_(Stats.f_12968_);
        return InteractionResult.CONSUME;
    }

    private static int addItemsToContainer(TreasureChestBlockEntity chest, ItemStack heldItem) {
        NonNullList<ItemStack> items = chest.getItems();
        int totalCount = 0;
        for (ItemStack item : items) {
            totalCount += item.m_41613_();
        }
        int maxStackSize = chest.maxStackSize;
        int spaceLeft = maxStackSize - totalCount;
        int amountToAdd = spaceLeft <= 0 ? heldItem.m_41613_() : Math.min(spaceLeft, heldItem.m_41613_());
        return amountToAdd;
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        BlockEntity blockEntity = (BlockEntity)builder.m_287159_(LootContextParams.f_81462_);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
            ItemStack drop = new ItemStack((ItemLike)this);
            if (chest.hasContents()) {
                CompoundTag nbt = new CompoundTag();
                CompoundTag blockEntityNbt = new CompoundTag();
                chest.m_183515_(blockEntityNbt);
                nbt.m_128365_("BlockEntityTag", (Tag)blockEntityNbt);
                drop.m_41751_(nbt);
            }
            return Collections.singletonList(drop);
        }
        return super.m_49635_(state, builder);
    }

    private void spawnItemEntity(Level level, BlockPos pos, ItemStack stack) {
        if (!stack.m_41619_()) {
            BlockState state = level.m_8055_(pos);
            int rotation = (Integer)state.m_61143_((Property)ROTATION);
            double angle = Math.toRadians(((float)rotation * 22.5f + 180.0f) % 360.0f);
            double offsetX = -Math.sin(angle) * 0.7;
            double offsetZ = Math.cos(angle) * 0.7;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stack);
            double speed = 0.1 + level.f_46441_.m_188500_() * 0.05;
            itemEntity.m_20334_(offsetX * speed, 0.2 + level.f_46441_.m_188500_() * 0.1, offsetZ * speed);
            level.m_5594_(null, pos, SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        TreasureChestBlockEntity chest;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreasureChestBlockEntity && (chest = (TreasureChestBlockEntity)blockEntity).isOwner(player.m_20148_())) {
            return super.m_5880_(state, player, level, pos);
        }
        return 0.0f;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TreasureChestBlockEntity) {
            TreasureChestBlockEntity chest = (TreasureChestBlockEntity)blockEntity;
            if (!level.f_46443_ && player.m_7500_() && chest.hasContents()) {
                ItemStack itemStack = new ItemStack((ItemLike)this);
                CompoundTag nbt = new CompoundTag();
                CompoundTag blockEntityNbt = new CompoundTag();
                chest.m_183515_(blockEntityNbt);
                nbt.m_128365_("BlockEntityTag", (Tag)blockEntityNbt);
                itemStack.m_41751_(nbt);
                ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
                itemEntity.m_32060_();
                level.m_7967_((Entity)itemEntity);
            }
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!state.m_60713_(newState.m_60734_())) {
            super.m_6810_(state, level, pos, newState, isMoving);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(rotation.m_55949_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(mirror.m_54843_(((Integer)state.m_61143_((Property)ROTATION)).intValue(), 16)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{ROTATION, OPEN});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos origin, BlockState state) {
        return new TreasureChestBlockEntity(origin, state);
    }
}

