/*
 * Decompiled with CFR 0.152.
 */
package io.github.chakyl.whimsydeco.datagen;

import io.github.chakyl.whimsydeco.blocks.ToyPlaneBlock;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class ModBlockStateProvider
extends BlockStateProvider {
    private static final int DEFAULT_ANGLE_OFFSET = 180;

    public ModBlockStateProvider(PackOutput output, ExistingFileHelper exFileHelper) {
        super(output, "whimsy_deco", exFileHelper);
    }

    private String blockName(Block block) {
        return ForgeRegistries.BLOCKS.getKey((Object)block).m_135815_();
    }

    public ResourceLocation resourceBlock(String path) {
        return new ResourceLocation("whimsy_deco", "block/" + path);
    }

    public ModelFile existingModel(Block block) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(this.blockName(block)), this.models().existingFileHelper);
    }

    public ModelFile existingModel(String path) {
        return new ModelFile.ExistingModelFile(this.resourceBlock(path), this.models().existingFileHelper);
    }

    protected void registerStatesAndModels() {
    }

    public void simpleHorizontalState(Block block, String color) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Object chair = color != null ? color + "_froggy_chair" : "froggy_chair";
            return ConfiguredModel.builder().modelFile(this.existingModel((String)chair)).build();
        });
    }

    public void customDirectionalBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        }, ignored);
    }

    public void customDirectionalTallBlock(Block block, Function<BlockState, ModelFile> modelFunc, Property<?> ... ignored) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            Direction dir = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunc.apply((BlockState)state)).rotationY(dir.m_122434_().m_122478_() ? 0 : ((int)dir.m_122435_() + 180) % 360).build();
        }, ignored);
    }

    public void toyPlaneStates(Block block, String color) {
        this.getVariantBuilder(block).forAllStates(state -> {
            boolean flying = (Boolean)state.m_61143_((Property)ToyPlaneBlock.FLYING);
            String plane = color + "_toy_plane" + (flying ? "_fly" : "");
            return ConfiguredModel.builder().modelFile(this.existingModel(plane)).build();
        });
    }
}

