/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.core.mixin;

import com.teamabnormals.atmospheric.common.entity.CamelVariant;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.animal.camel.Camel;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Camel.class})
public class CamelMixin
extends AbstractHorse
implements VariantHolder<CamelVariant> {
    @Unique
    private static final EntityDataAccessor<Integer> DATA_TYPE_ID = SynchedEntityData.m_135353_(Camel.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    protected CamelMixin(EntityType<? extends AbstractHorse> entity, Level level) {
        super(entity, level);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        tag.m_128405_("CamelType", this.getVariant().id());
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="TAIL")})
    private void defineSynchedData(CallbackInfo ci) {
        this.f_19804_.m_135372_(DATA_TYPE_ID, (Object)CamelVariant.DESERT.id());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(CompoundTag tag, CallbackInfo ci) {
        this.setVariant(CamelVariant.byId(tag.m_128451_("CamelType")));
    }

    @Inject(method={"finalizeSpawn"}, at={@At(value="HEAD")})
    private void readAdditionalSaveData(ServerLevelAccessor level, DifficultyInstance p_251264_, MobSpawnType p_250254_, SpawnGroupData p_249259_, CompoundTag p_251838_, CallbackInfoReturnable<SpawnGroupData> cir) {
        if (level.m_204166_(this.m_20183_()).m_203656_(AtmosphericBiomeTags.SPAWNS_ARID_CAMELS)) {
            this.setVariant(CamelVariant.ARID);
        }
    }

    @Inject(method={"getBreedOffspring(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/AgeableMob;)Lnet/minecraft/world/entity/AgeableMob;"}, at={@At(value="RETURN")}, cancellable=true)
    private void getBreedOffspring(ServerLevel level, AgeableMob ageableMob, CallbackInfoReturnable<Camel> cir) {
        Camel camel = (Camel)cir.getReturnValue();
        if (ageableMob instanceof Camel) {
            CamelVariant parentVariant;
            Camel camelParent = (Camel)ageableMob;
            VariantHolder child = (VariantHolder)camel;
            VariantHolder parent = (VariantHolder)camelParent;
            CamelVariant variant = this.getVariant();
            if (variant == (parentVariant = (CamelVariant)((Object)parent.m_28554_()))) {
                child.m_28464_((Object)variant);
            } else if (variant.id() + parentVariant.id() == 1) {
                child.m_28464_((Object)CamelVariant.HYBRID);
            } else {
                child.m_28464_((Object)(this.f_19796_.m_188499_() ? variant : parentVariant));
            }
            cir.setReturnValue((Object)((Camel)child));
        }
    }

    public void setVariant(CamelVariant variant) {
        this.f_19804_.m_135381_(DATA_TYPE_ID, (Object)variant.id());
    }

    public CamelVariant getVariant() {
        return CamelVariant.byId((Integer)this.f_19804_.m_135370_(DATA_TYPE_ID));
    }
}

