/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.levelgen.feature;

import com.google.common.collect.Lists;
import com.mojang.serialization.Codec;
import com.teamabnormals.atmospheric.common.block.DragonRootsBlock;
import com.teamabnormals.atmospheric.common.block.state.properties.DragonRootsStage;
import com.teamabnormals.atmospheric.core.registry.AtmosphericBlocks;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraftforge.common.Tags;

public class DragonRootsFeature
extends Feature<NoneFeatureConfiguration> {
    public DragonRootsFeature(Codec<NoneFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel level = context.m_159774_();
        RandomSource random = context.m_225041_();
        BlockPos origin = context.m_159777_();
        Direction direction = null;
        ArrayList positions = Lists.newArrayList();
        BlockState rootsState = ((Block)AtmosphericBlocks.DRAGON_ROOTS.get()).m_49966_();
        for (int j = 0; j < 256; ++j) {
            BlockPos offsetPos;
            if (direction == null) {
                offsetPos = origin.m_7918_(random.m_188503_(7) - random.m_188503_(7), random.m_188503_(3) - random.m_188503_(3), random.m_188503_(7) - random.m_188503_(7));
                for (Direction dir : DragonRootsBlock.FACING.m_6908_()) {
                    if (!DragonRootsFeature.isOnSandstone(level, offsetPos, dir) || !level.m_46859_(offsetPos)) continue;
                    direction = dir;
                    rootsState = (BlockState)rootsState.m_61124_((Property)DragonRootsBlock.FACING, (Comparable)direction.m_122424_());
                }
            } else {
                int wideOffset = random.m_188503_(8) - random.m_188503_(8);
                int shortOffset = random.m_188503_(3) - random.m_188503_(3);
                boolean xAxis = direction.m_122434_() != Direction.Axis.X;
                offsetPos = origin.m_7918_(xAxis ? wideOffset : shortOffset, random.m_188503_(3) - random.m_188503_(3), xAxis ? shortOffset : wideOffset);
            }
            if (direction == null || !DragonRootsFeature.isOnSandOrSandstone(level, offsetPos, direction) || !level.m_46859_(offsetPos) || !rootsState.m_60710_((LevelReader)level, offsetPos) || positions.contains(offsetPos)) continue;
            positions.add(offsetPos);
        }
        if (positions.size() > 16) {
            for (BlockPos pos : positions) {
                boolean top = random.m_188499_();
                boolean doubleRoots = random.m_188499_();
                BlockState roots = (BlockState)((BlockState)rootsState.m_61124_(DragonRootsBlock.TOP_STAGE, (Comparable)((Object)(top || doubleRoots ? DragonRootsStage.FRUIT : DragonRootsStage.NONE)))).m_61124_(DragonRootsBlock.BOTTOM_STAGE, (Comparable)((Object)(!top || doubleRoots ? DragonRootsStage.FRUIT : DragonRootsStage.NONE)));
                level.m_7731_(pos, roots, 2);
            }
            return true;
        }
        return false;
    }

    public static boolean isOnSandstone(WorldGenLevel level, BlockPos pos, Direction direction) {
        BlockState state = level.m_8055_(pos.m_121945_(direction));
        return state.m_204336_(Tags.Blocks.SANDSTONE) || state.m_60713_((Block)AtmosphericBlocks.ARID_SANDSTONE.get());
    }

    public static boolean isOnSandOrSandstone(WorldGenLevel level, BlockPos pos, Direction direction) {
        return level.m_8055_(pos.m_121945_(direction)).m_204336_(BlockTags.f_13029_) || DragonRootsFeature.isOnSandstone(level, pos, direction);
    }
}

