/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamabnormals.atmospheric.core.registry.AtmosphericRegistries;
import net.minecraft.Util;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;

public record TetraVariant(Component displayName, ResourceLocation texture, int weight) {
    public static final ResourceKey<TetraVariant> NEON = TetraVariant.createKey("neon");
    public static final ResourceKey<TetraVariant> CARDINAL = TetraVariant.createKey("cardinal");
    public static final ResourceKey<TetraVariant> BEACON = TetraVariant.createKey("beacon");
    public static final ResourceKey<TetraVariant> DIAMOND = TetraVariant.createKey("diamond");
    public static final ResourceKey<TetraVariant> EMPEROR = TetraVariant.createKey("emperor");
    public static final ResourceKey<TetraVariant> FLAME = TetraVariant.createKey("flame");
    public static final ResourceKey<TetraVariant> JEWEL = TetraVariant.createKey("jewel");
    public static final ResourceKey<TetraVariant> ORNATE = TetraVariant.createKey("ornate");
    public static final ResourceKey<TetraVariant> ROYAL = TetraVariant.createKey("royal");
    public static final Codec<TetraVariant> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.fieldOf("asset_id").forGetter(entry -> entry.texture), (App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(entry -> entry.weight)).apply((Applicative)instance, TetraVariant::new));
    public static final Codec<TetraVariant> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.f_252442_.fieldOf("description").forGetter(entry -> entry.displayName), (App)ResourceLocation.f_135803_.fieldOf("asset_id").forGetter(entry -> entry.texture)).apply((Applicative)instance, (desc, asset) -> new TetraVariant((Component)desc, (ResourceLocation)asset, -1)));

    public static void bootstrap(BootstapContext<TetraVariant> context) {
        TetraVariant.registerVariant(context, NEON, 50);
        TetraVariant.registerVariant(context, CARDINAL, 50);
        TetraVariant.registerVariant(context, BEACON, 1);
        TetraVariant.registerVariant(context, DIAMOND, 1);
        TetraVariant.registerVariant(context, EMPEROR, 1);
        TetraVariant.registerVariant(context, FLAME, 1);
        TetraVariant.registerVariant(context, JEWEL, 1);
        TetraVariant.registerVariant(context, ORNATE, 1);
        TetraVariant.registerVariant(context, ROYAL, 1);
    }

    public static void registerVariant(BootstapContext<TetraVariant> context, ResourceKey<TetraVariant> key, int weight) {
        context.m_255272_(key, (Object)new TetraVariant((Component)Component.m_237115_((String)Util.m_137492_((String)"tetra_variant", (ResourceLocation)key.m_135782_())), key.m_135782_().m_246208_("entity/tetra/"), weight));
    }

    public static ResourceKey<TetraVariant> createKey(String name) {
        return ResourceKey.m_135785_(AtmosphericRegistries.TETRA_VARIANT, (ResourceLocation)new ResourceLocation("atmospheric", name));
    }
}

