/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.atmospheric.common.entity;

import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealAttachToCactusGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealBreedGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealDetachFromCactusGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealEatDragonFruitGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealPanicGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealRandomHopGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealRandomSwimGoal;
import com.teamabnormals.atmospheric.common.entity.ai.goal.CochinealTemptGoal;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBiomeTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericBlockTags;
import com.teamabnormals.atmospheric.core.other.tags.AtmosphericItemTags;
import com.teamabnormals.atmospheric.core.registry.AtmosphericEntityTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericParticleTypes;
import com.teamabnormals.atmospheric.core.registry.AtmosphericSoundEvents;
import com.teamabnormals.blueprint.core.util.NetworkUtil;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.Nullable;

public class Cochineal
extends Animal
implements Saddleable {
    private static final EntityDimensions SUCKLING_DIMENSIONS = EntityDimensions.m_20395_((float)0.8f, (float)1.25f);
    private static final EntityDataAccessor<Boolean> IS_SADDLED = SynchedEntityData.m_135353_(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LEAPING = SynchedEntityData.m_135353_(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Optional<BlockPos>> CACTUS_POS = SynchedEntityData.m_135353_(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.f_135039_);
    private static final EntityDataAccessor<Direction> CACTUS_SIDE = SynchedEntityData.m_135353_(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.f_135040_);
    private static final EntityDataAccessor<ItemStack> EATING_STACK = SynchedEntityData.m_135353_(Cochineal.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private BlockPos lastHabitatBiomePos;
    private int forgetHabitatBiomePosCounter;
    private boolean wasOnGroundOrFluid;
    private boolean jumpingQuickly;
    private boolean superInLove;
    private int jumpDelayTicks;
    private int suckleCooldown;
    private int suckleHealTicks;
    private boolean jumpAnim;
    private float jumpAmount;
    private float jumpAmount0;

    public Cochineal(EntityType<? extends Cochineal> entity, Level level) {
        super(entity, level);
        this.f_21342_ = new CochinealMoveControl(this);
    }

    public Cochineal(PlayMessages.SpawnEntity message, Level level) {
        this((EntityType<? extends Cochineal>)((EntityType)AtmosphericEntityTypes.COCHINEAL.get()), level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new CochinealPanicGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new CochinealBreedGoal(this, 1.2));
        this.f_21345_.m_25352_(3, (Goal)new CochinealTemptGoal(this, 1.2, Ingredient.m_204132_(AtmosphericItemTags.COCHINEAL_FOOD)));
        this.f_21345_.m_25352_(4, (Goal)new CochinealEatDragonFruitGoal(this, 1.2));
        this.f_21345_.m_25352_(5, (Goal)new CochinealDetachFromCactusGoal(this));
        this.f_21345_.m_25352_(6, (Goal)new CochinealAttachToCactusGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new CochinealRandomSwimGoal(this, 1.2));
        this.f_21345_.m_25352_(8, (Goal)new CochinealRandomHopGoal(this));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.5).m_22268_((Attribute)ForgeMod.ENTITY_GRAVITY.get(), 0.04);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(AtmosphericItemTags.COCHINEAL_FOOD);
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.m_6254_()) {
            this.m_19998_((ItemLike)Items.f_42450_);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob partner) {
        return (AgeableMob)((EntityType)AtmosphericEntityTypes.COCHINEAL.get()).m_20615_((Level)level);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_SADDLED, (Object)false);
        this.f_19804_.m_135372_(IS_LEAPING, (Object)false);
        this.f_19804_.m_135372_(CACTUS_POS, Optional.empty());
        this.f_19804_.m_135372_(CACTUS_SIDE, (Object)Direction.SOUTH);
        this.f_19804_.m_135372_(EATING_STACK, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("SuperInLove", this.superInLove);
        tag.m_128379_("Saddle", this.m_6254_());
        if (this.isAttachedToCactus()) {
            tag.m_128365_("CactusPos", (Tag)NbtUtils.m_129224_((BlockPos)this.getCactusPos()));
            tag.m_128359_("CactusSide", this.getCactusSide().m_122433_());
        }
        if (this.lastHabitatBiomePos != null) {
            tag.m_128365_("LastHabitatBiomePos", (Tag)NbtUtils.m_129224_((BlockPos)this.lastHabitatBiomePos));
            tag.m_128405_("ForgetHabitatBiomePosCounter", this.forgetHabitatBiomePosCounter);
        }
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.superInLove = tag.m_128471_("SuperInLove");
        this.setSaddle(tag.m_128471_("Saddle"));
        if (tag.m_128441_("CactusPos")) {
            this.setCactusPos(NbtUtils.m_129239_((CompoundTag)tag.m_128469_("CactusPos")));
            this.setCactusSide(Direction.m_122402_((String)tag.m_128461_("CactusSide")));
            this.suckleHealTicks = 120;
        }
        if (tag.m_128441_("LastHabitatBiomePos")) {
            this.lastHabitatBiomePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("LastHabitatBiomePos"));
            this.forgetHabitatBiomePosCounter = tag.m_128451_("ForgetHabitatBiomePosCounter");
        }
    }

    public boolean m_6254_() {
        return (Boolean)this.f_19804_.m_135370_(IS_SADDLED);
    }

    public void setSaddle(boolean saddle) {
        this.f_19804_.m_135381_(IS_SADDLED, (Object)saddle);
    }

    public boolean isLeaping() {
        return (Boolean)this.f_19804_.m_135370_(IS_LEAPING);
    }

    public void setLeaping(boolean leaping) {
        this.f_19804_.m_135381_(IS_LEAPING, (Object)leaping);
    }

    public void setJumpingQuickly(boolean jumpingQuickly) {
        this.jumpingQuickly = jumpingQuickly;
    }

    public boolean isSuperInLove() {
        return this.superInLove;
    }

    public void setSuperInLove(boolean superInLove) {
        this.superInLove = superInLove;
    }

    public BlockPos getCactusPos() {
        return ((Optional)this.f_19804_.m_135370_(CACTUS_POS)).orElse(null);
    }

    public void setCactusPos(BlockPos pos) {
        this.f_19804_.m_135381_(CACTUS_POS, Optional.ofNullable(pos));
    }

    public Direction getCactusSide() {
        return (Direction)this.f_19804_.m_135370_(CACTUS_SIDE);
    }

    public void setCactusSide(Direction side) {
        this.f_19804_.m_135381_(CACTUS_SIDE, (Object)side);
    }

    public ItemStack getEatingStack() {
        return (ItemStack)this.f_19804_.m_135370_(EATING_STACK);
    }

    public void setEatingStack(ItemStack stack) {
        this.f_19804_.m_135381_(EATING_STACK, (Object)stack);
    }

    public boolean isOnSuckleCooldown() {
        return this.suckleCooldown > 0;
    }

    public BlockPos getLastHabitatBiomePos() {
        double dz;
        double dx;
        if (this.lastHabitatBiomePos != null && (dx = this.m_20185_() - (double)this.lastHabitatBiomePos.m_123341_()) * dx + (dz = this.m_20189_() - (double)this.lastHabitatBiomePos.m_123343_()) * dz > 16384.0) {
            this.lastHabitatBiomePos = null;
        }
        return this.lastHabitatBiomePos;
    }

    public boolean isAttachedToCactus() {
        return this.getCactusPos() != null;
    }

    public void attachToCactus(BlockPos cactusPos, Direction cactusSide) {
        this.setCactusPos(cactusPos);
        this.setCactusSide(cactusSide);
        this.m_20256_(Vec3.f_82478_);
        this.m_146884_(this.getCactusAttachPoint(cactusPos, cactusSide));
        this.m_20153_();
        this.m_147244_(false);
        this.setLeaping(false);
        this.suckleHealTicks = 120;
        this.suckleCooldown = 200;
        this.m_5496_((SoundEvent)AtmosphericSoundEvents.COCHINEAL_GRAB.get(), 1.0f, 0.8f / (this.m_217043_().m_188501_() * 0.8f + 0.8f));
    }

    public void detachFromCactus() {
        this.setCactusPos(null);
        this.suckleCooldown = 100;
    }

    private Vec3 getCactusAttachPoint(BlockPos cactusPos, Direction cactusSide) {
        VoxelShape shape = this.m_9236_().m_8055_(cactusPos).m_60812_((BlockGetter)this.m_9236_(), cactusPos);
        double x = cactusPos.m_123341_();
        double z = cactusPos.m_123343_();
        if (cactusSide.m_122434_() == Direction.Axis.X) {
            x += cactusSide == Direction.WEST ? shape.m_83288_(Direction.Axis.X) : shape.m_83297_(Direction.Axis.X);
            z += 0.5;
            x += (double)this.m_20205_() * 0.5 * (double)cactusSide.m_122429_();
        } else {
            x += 0.5;
            z += cactusSide == Direction.NORTH ? shape.m_83288_(Direction.Axis.Z) : shape.m_83297_(Direction.Axis.Z);
            z += (double)this.m_20205_() * 0.5 * (double)cactusSide.m_122431_();
        }
        return new Vec3(x, (double)cactusPos.m_123342_() + 0.5 - (double)this.m_20206_() * 0.5, z);
    }

    public boolean isSuckleable(BlockPos pos) {
        return this.m_9236_().m_8055_(pos).m_204336_(AtmosphericBlockTags.COCHINEALS_CAN_FEED_ON);
    }

    public Direction getClosestVisibleCactusFace(BlockPos cactusPos) {
        Direction closestdir = null;
        double closestdist = Double.MAX_VALUE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            double distance;
            BlockPos sidepos = cactusPos.m_121945_(direction);
            Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
            Vec3 vec31 = new Vec3((double)sidepos.m_123341_() + 0.5, (double)sidepos.m_123342_() + 0.5, (double)sidepos.m_123343_() + 0.5);
            if (!this.hasSpaceOnCactusSide(cactusPos, direction) || this.m_9236_().m_45547_(new ClipContext(vec3, vec31, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() != HitResult.Type.MISS || !((distance = this.m_20275_(sidepos.m_123341_(), sidepos.m_123342_(), sidepos.m_123343_())) < closestdist)) continue;
            closestdir = direction;
            closestdist = distance;
        }
        return closestdir;
    }

    public boolean hasSpaceOnCactusSide(BlockPos cactusPos, Direction cactusSide) {
        double x;
        AABB aabb = new AABB(0.0, 0.5 - (double)this.m_20206_() * 0.5, 0.0, 1.0, 0.5 + (double)this.m_20206_() * 0.5, 1.0).m_82406_(1.0E-6);
        VoxelShape shape = this.m_9236_().m_8055_(cactusPos).m_60812_((BlockGetter)this.m_9236_(), cactusPos);
        double d = cactusSide == Direction.WEST ? shape.m_83288_(Direction.Axis.X) - 1.0 : (x = cactusSide == Direction.EAST ? shape.m_83297_(Direction.Axis.X) : 0.0);
        double z = cactusSide == Direction.NORTH ? shape.m_83288_(Direction.Axis.Z) - 1.0 : (cactusSide == Direction.SOUTH ? shape.m_83297_(Direction.Axis.Z) : 0.0);
        aabb = aabb.m_82386_((double)cactusPos.m_123341_() + x, (double)cactusPos.m_123342_(), (double)cactusPos.m_123343_() + z);
        for (VoxelShape voxelshape : this.m_9236_().m_186434_((Entity)this, aabb)) {
            if (voxelshape.m_83281_()) continue;
            return false;
        }
        for (Cochineal cochineal : this.m_9236_().m_45976_(Cochineal.class, aabb)) {
            if (cochineal == this || !cochineal.isAttachedToCactus()) continue;
            return false;
        }
        return true;
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (this.m_6898_(stack)) {
            int i = this.m_146764_();
            if (!this.m_9236_().f_46443_ && i == 0 && this.m_5957_()) {
                this.m_142075_(player, hand, stack);
                this.m_27595_(player);
                if (stack.m_204117_(AtmosphericItemTags.COCHINEAL_SUPER_LOVE_FOOD)) {
                    this.setSuperInLove(true);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_6162_()) {
                this.m_142075_(player, hand, stack);
                this.m_146740_(Cochineal.m_216967_((int)(-i)), true);
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (this.m_9236_().f_46443_) {
                return InteractionResult.CONSUME;
            }
        } else {
            if (this.m_6254_() && !this.m_20160_() && !player.m_36341_() && !this.isAttachedToCactus()) {
                if (!this.m_9236_().f_46443_) {
                    player.m_20329_((Entity)this);
                }
                return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
            }
            if (stack.m_150930_(Items.f_42450_)) {
                return stack.m_41647_(player, (LivingEntity)this, hand);
            }
        }
        return InteractionResult.PASS;
    }

    public void m_5853_(@Nullable SoundSource source) {
        this.f_19804_.m_135381_(IS_SADDLED, (Object)true);
        if (source != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12236_, source, 0.5f, 1.0f);
        }
    }

    public void m_7822_(byte id) {
        if (id == 1) {
            this.m_20076_();
            this.jumpAnim = true;
        } else {
            super.m_7822_(id);
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.jumpDelayTicks > 0) {
            --this.jumpDelayTicks;
        }
        if ((this.m_20096_() || this.isInFluidType()) && !this.wasOnGroundOrFluid) {
            this.m_147244_(false);
            this.setLeaping(false);
            this.jumpDelayTicks = this.jumpingQuickly ? 2 : 10;
        }
        boolean bl = this.wasOnGroundOrFluid = this.m_20096_() || this.isInFluidType();
        if (this.isAttachedToCactus()) {
            if (this.isSuckleable(this.getCactusPos()) && this.m_20238_(this.getCactusAttachPoint(this.getCactusPos(), this.getCactusSide())) < 0.2) {
                this.m_20256_(Vec3.f_82478_);
                this.m_146922_(this.getCactusSide().m_122424_().m_122435_());
                this.f_20885_ = this.m_146908_();
                this.f_20883_ = this.m_146908_();
            } else if (!this.m_9236_().f_46443_) {
                this.detachFromCactus();
            }
        }
    }

    public void m_8107_() {
        if (!this.m_9236_().f_46443_ && this.m_6084_() && this.m_146764_() < 0 && !this.isAttachedToCactus()) {
            this.m_146762_(this.f_146733_ - 1);
        }
        super.m_8107_();
        if (this.m_27591_() == 0) {
            this.setSuperInLove(false);
        }
        this.jumpAmount0 = this.jumpAmount;
        if (this.jumpAnim) {
            if (this.jumpAmount < 1.0f) {
                this.jumpAmount = Math.min(this.jumpAmount + 0.5f, 1.0f);
            } else {
                this.jumpAnim = false;
            }
        } else if (this.jumpAmount > 0.0f) {
            this.jumpAmount = Math.max(this.jumpAmount - 0.1f, 0.0f);
        }
        if (this.m_6084_()) {
            if (!this.m_9236_().f_46443_) {
                if (this.suckleCooldown > 0) {
                    --this.suckleCooldown;
                }
                if (this.m_21223_() < this.m_21233_() && this.isAttachedToCactus() && this.suckleHealTicks-- <= 0) {
                    this.m_5634_(1.0f);
                    this.suckleHealTicks = 120;
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    NetworkUtil.spawnParticle((String)"minecraft:heart", (double)this.m_20208_(1.0), (double)this.m_20187_(), (double)this.m_20262_(1.0), (double)d0, (double)d1, (double)d2);
                }
            } else {
                if (this.isLeaping() || this.f_20916_ > 0) {
                    boolean cold = ((Biome)this.m_9236_().m_204166_(this.m_20183_()).get()).m_198904_(this.m_20183_());
                    for (int i = 0; i < 3; ++i) {
                        double x = -this.m_20154_().f_82479_ * 0.7 + (this.f_19796_.m_188500_() - 0.5) * 0.6;
                        double y = 0.6 + (this.f_19796_.m_188500_() - 0.5) * 0.6;
                        double z = -this.m_20154_().f_82481_ * 0.7 + (this.f_19796_.m_188500_() - 0.5) * 0.6;
                        if (this.m_6162_()) {
                            x *= 0.4;
                            y *= 0.4;
                            z *= 0.4;
                        }
                        this.m_9236_().m_7106_(cold ? (ParticleOptions)AtmosphericParticleTypes.COLD_COCHINEAL_TRAIL.get() : (ParticleOptions)AtmosphericParticleTypes.COCHINEAL_TRAIL.get(), this.m_20185_() + x, this.m_20186_() + y, this.m_20189_() + z, 0.0, 0.0, 0.0);
                    }
                }
                if (this.isAttachedToCactus() && this.m_6162_() && this.f_19796_.m_188503_(160) == 0) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123748_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), 0.0, 0.0, 0.0);
                }
            }
            if (this.isAttachedToCactus() && this.f_19796_.m_188503_(200) == 0) {
                this.m_5496_((SoundEvent)AtmosphericSoundEvents.COCHINEAL_SUCKLE.get(), 0.85f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
            }
            if (!this.getEatingStack().m_41619_() && this.f_19797_ % 12 == 0) {
                this.m_5496_((SoundEvent)AtmosphericSoundEvents.COCHINEAL_SUCKLE.get(), 1.4f, 0.4f / (this.m_217043_().m_188501_() * 0.4f + 0.8f));
                if (this.m_9236_().f_46443_) {
                    for (int i = 0; i < 6; ++i) {
                        Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, ((double)this.f_19796_.m_188501_() - 0.5) * 0.1);
                        vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
                        vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
                        double d0 = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
                        Vec3 vec31 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.8, d0, 0.8 + ((double)this.f_19796_.m_188501_() - 0.5) * 0.4);
                        vec31 = vec31.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
                        vec31 = vec31.m_82520_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
                        this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.getEatingStack()), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
                    }
                }
            }
        }
    }

    public void m_147240_(double force, double x, double z) {
        super.m_147240_(force, x, z);
        this.detachFromCactus();
    }

    protected void leap(double jumpPower) {
        Vec3 vec3 = this.m_20184_();
        double speed = ((CochinealMoveControl)this.f_21342_).leapSpeed;
        this.m_20334_(vec3.f_82479_, jumpPower + (double)this.m_285755_(), vec3.f_82481_);
        this.m_19920_((float)speed, new Vec3(0.0, 0.0, 1.0));
        this.setLeaping(true);
        this.m_9236_().m_7605_((Entity)this, (byte)1);
        if (this.m_9236_().m_204166_(this.m_20183_()).m_203656_(AtmosphericBiomeTags.IS_COCHINEAL_HABITAT)) {
            this.lastHabitatBiomePos = this.m_20183_();
            this.forgetHabitatBiomePosCounter = 100;
        } else if (this.lastHabitatBiomePos != null && this.forgetHabitatBiomePosCounter-- <= 0) {
            this.lastHabitatBiomePos = null;
        }
        this.f_19812_ = true;
        this.m_5496_((SoundEvent)AtmosphericSoundEvents.COCHINEAL_BOUNCE.get(), 2.5f, 0.8f / (this.m_217043_().m_188501_() * 0.2f + 0.8f));
        ForgeHooks.onLivingJump((LivingEntity)this);
    }

    public boolean canLeap() {
        return this.m_20096_() && !this.isLeaping() && !((CochinealMoveControl)this.f_21342_).wantsToLeap && this.jumpDelayTicks == 0;
    }

    public float getJumpAmount(float partialTick) {
        return Mth.m_14179_((float)partialTick, (float)this.jumpAmount0, (float)this.jumpAmount);
    }

    public int m_8132_() {
        return 0;
    }

    public int m_8085_() {
        return 5;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.4f : 1.0f;
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.isAttachedToCactus()) {
            return SUCKLING_DIMENSIONS.m_20388_(this.m_6134_());
        }
        return super.m_6972_(pose);
    }

    protected SoundEvent m_7975_(DamageSource p_29502_) {
        return (SoundEvent)AtmosphericSoundEvents.COCHINEAL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AtmosphericSoundEvents.COCHINEAL_DEATH.get();
    }

    protected void m_7355_(BlockPos p_29492_, BlockState p_29493_) {
    }

    protected void m_30232_() {
        if (!this.m_6162_() && this.isAttachedToCactus() && !this.hasSpaceOnCactusSide(this.getCactusPos(), this.getCactusSide())) {
            this.detachFromCactus();
        }
    }

    public boolean m_6094_() {
        return !this.isAttachedToCactus() && super.m_6094_();
    }

    protected void m_7324_(Entity entity) {
        if (!this.isAttachedToCactus()) {
            super.m_7324_(entity);
        }
    }

    protected void m_6138_() {
        if (!this.isAttachedToCactus()) {
            super.m_6138_();
        }
    }

    public boolean m_5843_() {
        return false;
    }

    public boolean m_142535_(float distance, float damageMultiplier, DamageSource source) {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (CACTUS_POS.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        BlockPos blockpos = this.m_20183_();
        if (this.m_9236_().m_204166_(blockpos).m_203656_(AtmosphericBiomeTags.IS_COCHINEAL_HABITAT)) {
            this.lastHabitatBiomePos = blockpos;
            this.forgetHabitatBiomePosCounter = 100;
        }
        return super.m_6518_(level, difficulty, spawnType, groupData, tag);
    }

    public MoveControl m_21566_() {
        return this.f_21342_;
    }

    protected PathNavigation m_6037_(Level level) {
        return new CochinealNavigation(this, level);
    }

    public static class CochinealMoveControl
    extends MoveControl {
        private final Cochineal cochineal;
        private double jumpX;
        private double jumpY;
        private double jumpZ;
        private boolean wantsToLeap;
        private int justLeapedTime;
        private double leapSpeed;

        public CochinealMoveControl(Cochineal cochineal) {
            super((Mob)cochineal);
            this.cochineal = cochineal;
        }

        public void m_8126_() {
            if (this.cochineal.isInFluidType()) {
                super.m_8126_();
                this.wantsToLeap = false;
                return;
            }
            if (this.cochineal.isLeaping()) {
                Vec3 vec3 = new Vec3(this.jumpX - this.f_24974_.m_20185_(), 0.0, this.jumpZ - this.f_24974_.m_20189_()).m_82541_();
                double d0 = this.cochineal.m_20184_().m_165924_();
                if (this.justLeapedTime > 0) {
                    --this.justLeapedTime;
                    if (d0 < this.leapSpeed) {
                        Vec3 vec31 = vec3.m_82490_(Math.min(0.2, this.leapSpeed - d0));
                        this.cochineal.m_20256_(this.cochineal.m_20184_().m_82549_(vec31));
                    }
                } else if (d0 < Math.min(0.1, this.leapSpeed)) {
                    Vec3 vec31 = vec3.m_82490_(Math.min(0.04, Math.min(0.1, this.leapSpeed) - d0));
                    this.cochineal.m_20256_(this.cochineal.m_20184_().m_82549_(vec31));
                }
                this.cochineal.m_147244_(true);
                this.stopSwimmingNaviation();
            } else if (this.cochineal.m_20096_()) {
                if (this.wantsToLeap && this.cochineal.jumpDelayTicks == 0) {
                    if (this.canReach(this.jumpX, this.jumpY, this.jumpZ)) {
                        double dx = this.jumpX - this.f_24974_.m_20185_();
                        double dy = this.jumpY - this.f_24974_.m_20186_();
                        double dz = this.jumpZ - this.f_24974_.m_20189_();
                        double distance = Math.sqrt(dx * dx + dz * dz);
                        this.faceJumpPoint();
                        double jumppower = this.cochineal.jumpingQuickly ? Mth.m_14008_((double)(0.4 + dy * 0.05), (double)0.4, (double)0.8) : Mth.m_14008_((double)(0.5 + dy * 0.05), (double)0.4, (double)0.8);
                        this.leapSpeed = this.calculateJumpSpeed(distance, dy, jumppower += (double)this.cochineal.m_285755_());
                        this.cochineal.leap(jumppower);
                        this.justLeapedTime = 3;
                    }
                    this.wantsToLeap = false;
                }
                this.stopSwimmingNaviation();
            }
        }

        public void leapTo(double x, double y, double z) {
            this.jumpX = x;
            this.jumpY = y;
            this.jumpZ = z;
            this.wantsToLeap = true;
            this.faceJumpPoint();
        }

        private void stopSwimmingNaviation() {
            this.f_24981_ = MoveControl.Operation.WAIT;
            this.cochineal.m_21573_().m_26573_();
            this.cochineal.m_21564_(0.0f);
        }

        public boolean canReach(double x, double y, double z) {
            double dx = x - this.f_24974_.m_20185_();
            double dy = y - this.f_24974_.m_20186_();
            double dz = z - this.f_24974_.m_20189_();
            return dy <= 8.0 && dy >= -8.0 && dx * dx + dz * dz <= 256.0;
        }

        private void faceJumpPoint() {
            this.cochineal.m_146922_((float)(Mth.m_14136_((double)(this.jumpZ - this.cochineal.m_20189_()), (double)(this.jumpX - this.cochineal.m_20185_())) * 57.2957763671875) - 90.0f);
            this.cochineal.f_20883_ = this.cochineal.m_146908_();
            this.cochineal.f_20885_ = this.cochineal.m_146908_();
        }

        private double calculateJumpSpeed(double distance, double height, double jumpPower) {
            double gravity = -this.cochineal.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            if (height == 0.0) {
                return -gravity * distance / Math.abs(jumpPower) / 2.0;
            }
            return distance * (jumpPower - Math.sqrt(jumpPower * jumpPower + 2.0 * height * gravity)) / height / 2.0;
        }
    }

    static class CochinealNavigation
    extends GroundPathNavigation {
        private final Cochineal cochineal;

        CochinealNavigation(Cochineal cochineal, Level level) {
            super((Mob)cochineal, level);
            this.cochineal = cochineal;
        }

        public boolean m_6342_(BlockPos pos) {
            return !this.cochineal.isInFluidType() ? this.f_26495_.m_8055_(pos.m_7495_()).m_60634_((BlockGetter)this.f_26495_, pos.m_7495_(), (Entity)this.f_26494_) : super.m_6342_(pos);
        }
    }
}

