/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.extractinator.forge;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import tech.alexnijjar.extractinator.client.ExtractinatorClient;
import tech.alexnijjar.extractinator.common.config.forge.ForgeMenuConfig;

public class ExtractinatorClientForge {
    private static final Map<Item, BlockEntityWithoutLevelRenderer> ITEM_RENDERERS = new HashMap<Item, BlockEntityWithoutLevelRenderer>();
    private static boolean hasInitializedRenderers = false;

    public static void init() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(ExtractinatorClientForge::modelLoading);
        ForgeMenuConfig.register();
    }

    public static void modelLoading(ModelEvent.RegisterAdditional event) {
        ExtractinatorClient.onRegisterModels(arg_0 -> ((ModelEvent.RegisterAdditional)event).register(arg_0));
    }

    public static void postInit() {
        ExtractinatorClient.onRegisterItemRenderers((item, renderer) -> ITEM_RENDERERS.put(item.m_5456_(), (BlockEntityWithoutLevelRenderer)renderer));
        ExtractinatorClient.onRegisterBlockRenderers((type, factory) -> BlockEntityRenderers.m_173590_((BlockEntityType)((BlockEntityType)type.get()), (BlockEntityRendererProvider)factory));
        hasInitializedRenderers = true;
    }

    public static BlockEntityWithoutLevelRenderer getItemRenderer(ItemLike item) {
        return ITEM_RENDERERS.get(item.m_5456_());
    }

    public static boolean hasInitializedRenderers() {
        return hasInitializedRenderers;
    }
}

