/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.craftingtweaks;

import net.blay09.mods.craftingtweaks.api.CraftingGridProvider;
import net.blay09.mods.craftingtweaks.api.CraftingTweaksAPI;
import net.blay09.mods.craftingtweaks.registry.CraftingTweaksRegistrationData;
import net.blay09.mods.craftingtweaks.registry.DataDrivenGridFactory;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMCHandler {
    private static final Logger logger = LoggerFactory.getLogger(IMCHandler.class);

    public static void processInterMod(InterModProcessEvent event) {
        event.getIMCStream(it -> it.equals("RegisterProvider") || it.equals("RegisterProviderV2") || it.equals("RegisterProviderV3")).forEach(message -> {
            CompoundTag tagCompound = (CompoundTag)message.messageSupplier().get();
            CraftingTweaksRegistrationData data = new CraftingTweaksRegistrationData();
            data.setModId(message.senderModId());
            data.setContainerClass(tagCompound.m_128461_("ContainerClass"));
            data.setContainerCallbackClass(tagCompound.m_128461_("ContainerCallback"));
            data.setValidContainerPredicateClass(tagCompound.m_128461_("ValidContainerPredicate"));
            data.setGetGridStartFunctionClass(tagCompound.m_128461_("GetGridStartFunction"));
            data.setGridSlotNumber(IMCHandler.getIntOr(tagCompound, "GridSlotNumber", 1));
            data.setGridSize(IMCHandler.getIntOr(tagCompound, "GridSize", 9));
            if (tagCompound.m_128441_("ButtonOffsetX")) {
                data.setButtonOffsetX(tagCompound.m_128451_("ButtonOffsetX"));
            }
            if (tagCompound.m_128441_("ButtonOffsetY")) {
                data.setButtonOffsetY(tagCompound.m_128451_("ButtonOffsetY"));
            }
            data.setAlignToGrid(tagCompound.m_128461_("AlignToGrid"));
            data.setButtonStyle(tagCompound.m_128461_("ButtonStyle"));
            data.setHideButtons(tagCompound.m_128471_("HideButtons"));
            data.setPhantomItems(tagCompound.m_128471_("PhantomItems"));
            CompoundTag rotateCompound = tagCompound.m_128469_("TweakRotate");
            CraftingTweaksRegistrationData.TweakData rotateTweak = new CraftingTweaksRegistrationData.TweakData();
            rotateTweak.setEnabled(IMCHandler.getBoolOr(rotateCompound, "Enabled", true));
            rotateTweak.setShowButton(IMCHandler.getBoolOr(rotateCompound, "ShowButton", true));
            if (rotateCompound.m_128441_("ButtonX")) {
                rotateTweak.setButtonX(rotateCompound.m_128451_("ButtonX"));
            }
            if (rotateCompound.m_128441_("ButtonY")) {
                rotateTweak.setButtonY(rotateCompound.m_128451_("ButtonY"));
            }
            data.setTweakRotate(rotateTweak);
            CompoundTag balanceCompound = tagCompound.m_128469_("TweakBalance");
            CraftingTweaksRegistrationData.TweakData balanceTweak = new CraftingTweaksRegistrationData.TweakData();
            balanceTweak.setEnabled(IMCHandler.getBoolOr(balanceCompound, "Enabled", true));
            balanceTweak.setShowButton(IMCHandler.getBoolOr(balanceCompound, "ShowButton", true));
            if (balanceCompound.m_128441_("ButtonX")) {
                balanceTweak.setButtonX(balanceCompound.m_128451_("ButtonX"));
            }
            if (balanceCompound.m_128441_("ButtonY")) {
                balanceTweak.setButtonY(balanceCompound.m_128451_("ButtonY"));
            }
            data.setTweakBalance(balanceTweak);
            CompoundTag clearCompound = tagCompound.m_128469_("TweakClear");
            CraftingTweaksRegistrationData.TweakData clearTweak = new CraftingTweaksRegistrationData.TweakData();
            clearTweak.setEnabled(IMCHandler.getBoolOr(clearCompound, "Enabled", true));
            clearTweak.setShowButton(IMCHandler.getBoolOr(clearCompound, "ShowButton", true));
            if (clearCompound.m_128441_("ButtonX")) {
                clearTweak.setButtonX(clearCompound.m_128451_("ButtonX"));
            }
            if (clearCompound.m_128441_("ButtonY")) {
                clearTweak.setButtonY(clearCompound.m_128451_("ButtonY"));
            }
            data.setTweakClear(clearTweak);
            CraftingGridProvider gridProvider = DataDrivenGridFactory.createGridProvider(data);
            if (gridProvider != null) {
                CraftingTweaksAPI.registerCraftingGridProvider(gridProvider);
                logger.info("{} has registered {} for CraftingTweaks via IMC", (Object)data.getModId(), (Object)data.getContainerClass());
            }
        });
    }

    private static int getIntOr(CompoundTag tagCompound, String key, int defaultVal) {
        return tagCompound.m_128441_(key) ? tagCompound.m_128451_(key) : defaultVal;
    }

    private static boolean getBoolOr(CompoundTag tagCompound, String key, boolean defaultVal) {
        return tagCompound.m_128441_(key) ? tagCompound.m_128471_(key) : defaultVal;
    }
}

