/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.api.StructurifyStructure;
import com.faboslav.structurify.common.api.StructurifyStructurePlacement;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public final class StructurifyRegistryUpdater {
    public static void updateRegistries(UpdateRegistriesEvent event) {
        if (!Structurify.getConfig().isLoaded) {
            return;
        }
        try {
            Structurify.getLogger().info("Updating registries...");
            HolderLookup.Provider registryManager = event.registryManager();
            if (registryManager == null) {
                return;
            }
            StructurifyRegistryUpdater.updateStructures(registryManager);
            StructurifyRegistryUpdater.updateStructureSets(registryManager);
            Structurify.getLogger().info("Registries updated");
        }
        catch (Exception e) {
            Structurify.getLogger().info("Failed to update registries");
        }
    }

    private static void updateStructures(HolderLookup.Provider registryManager) {
        HolderLookup.RegistryLookup structureRegistry = registryManager.m_254861_(Registries.f_256944_).orElse(null);
        if (structureRegistry == null) {
            return;
        }
        for (Holder.Reference structureReference : structureRegistry.m_214062_().toList()) {
            Structure structure = (Structure)structureReference.m_203334_();
            ResourceKey structureRegistryKey = structureReference.m_205785_();
            ResourceLocation structureId = structureRegistryKey.m_135782_();
            StructurifyStructure structurifyStructure = (StructurifyStructure)structure;
            structurifyStructure.structurify$setStructureIdentifier(structureId);
            structurifyStructure.structurify$setStructureBiomes(null);
        }
        Structurify.getLogger().info("Structure registries updated");
    }

    private static void updateStructureSets(HolderLookup.Provider registryManager) {
        HolderLookup.RegistryLookup structureSetRegistry = registryManager.m_254861_(Registries.f_256998_).orElse(null);
        if (structureSetRegistry == null) {
            return;
        }
        for (Holder.Reference structureSetReference : structureSetRegistry.m_214062_().toList()) {
            StructureSet structureSet = (StructureSet)structureSetReference.m_203334_();
            ResourceKey structureSetRegistryKey = structureSetReference.m_205785_();
            ResourceLocation structureSetId = structureSetRegistryKey.m_135782_();
            StructurifyStructurePlacement structurifyStructurePlacement = (StructurifyStructurePlacement)structureSet.f_210004_();
            structurifyStructurePlacement.structurify$setStructureSetIdentifier(structureSetId);
        }
        Structurify.getLogger().info("Structure Sets registries updated");
    }
}

