/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.commands;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.mixin.LocateCommandInvoker;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class StructurifyCommand {
    public static void createCommand(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"structurify").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"dump").executes(ctx -> {
            Structurify.getConfig().dump();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Structurify config dumped to \"" + String.valueOf(Structurify.getConfig().configDumpPath) + "\".")), !((CommandSourceStack)ctx.getSource()).m_230897_());
            return 1;
        }))).then(Commands.m_82127_((String)"locate").then(Commands.m_82127_((String)"structure").then(Commands.m_82129_((String)"structure", (ArgumentType)ResourceOrTagKeyArgument.m_247494_((ResourceKey)Registries.f_256944_)).executes(commandContext -> StructurifyCommand.locateStructure((CommandSourceStack)commandContext.getSource(), (ResourceOrTagKeyArgument.Result<Structure>)ResourceOrTagKeyArgument.m_246379_((CommandContext)commandContext, (String)"structure", (ResourceKey)Registries.f_256944_, (DynamicCommandExceptionType)LocateCommandInvoker.structurify$getStructureInvalidError())))))));
    }

    private static int locateStructure(CommandSourceStack source, ResourceOrTagKeyArgument.Result<Structure> structure) throws CommandSyntaxException {
        ServerLevel serverLevel = source.m_81372_();
        BlockPos blockPos = BlockPos.m_274446_((Position)source.m_81371_());
        Registry registry = source.m_81372_().m_9598_().m_175515_(Registries.f_256944_);
        HolderSet holderSet = (HolderSet)LocateCommandInvoker.structurify$invokeGetHolders(structure, (Registry<Structure>)registry).orElseThrow(() -> LocateCommandInvoker.structurify$getStructureInvalidError().create((Object)structure.m_245390_()));
        source.m_288197_(() -> Component.m_237113_((String)("Locating " + structure.m_245390_() + " in the radius of " + LocateCommandInvoker.structurify$getMaxStructureSearchRadius() + " chunks")), false);
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.f_211544_);
        CompletableFuture.supplyAsync(() -> serverLevel.m_7726_().m_8481_().m_223037_(serverLevel, holderSet, blockPos, LocateCommandInvoker.structurify$getMaxStructureSearchRadius(), false), Util.m_183991_()).thenAcceptAsync(pair -> {
            stopwatch.stop();
            source.m_81377_().execute(() -> {
                if (pair == null) {
                    source.m_81352_((Component)Component.m_237115_((String)LocateCommandInvoker.structurify$getStructureNotFoundError().create((Object)structure.m_245390_()).getLocalizedMessage()));
                } else {
                    LocateCommand.m_262810_((CommandSourceStack)source, (ResourceOrTagKeyArgument.Result)structure, (BlockPos)blockPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
                }
            });
        }, (Executor)Util.m_183991_());
        return 0;
    }
}

