/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.checks;

import com.faboslav.structurify.common.config.data.StructureData;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldGenerationContext;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;

public final class JigsawStructureFlatnessCheck {
    public static boolean checkFlatness(StructureData structureData, HeightProvider startHeight, Structure.GenerationContext generationContext) {
        int flatnessCheckDistance = structureData.getFlatnessCheckDistance();
        int flatnessCheckThreshold = structureData.getFlatnessCheckThreshold();
        boolean areAirBlocksAllowed = structureData.areAirBlocksAllowedInFlatnessCheck();
        boolean areLiquidBlocksAllowed = structureData.areLiquidBlocksAllowedInFlatnessCheck();
        if (flatnessCheckDistance == 0 || flatnessCheckThreshold == 0) {
            return true;
        }
        int offsetStep = (int)Math.ceil((float)flatnessCheckDistance / 2.0f);
        int stepsPerAxis = 2 * flatnessCheckDistance / offsetStep + 1;
        int stepAmount = stepsPerAxis * stepsPerAxis;
        int allowedAirBlockSteps = stepAmount / 2;
        int allowedLiquidBlockSteps = stepAmount / 2;
        ChunkGenerator chunkGenerator = generationContext.f_226622_();
        LevelHeightAccessor heightAccessor = generationContext.f_226629_();
        RandomState randomState = generationContext.f_226624_();
        ChunkPos chunkPos = generationContext.f_226628_();
        int y = startHeight.m_213859_((RandomSource)generationContext.f_226626_(), new WorldGenerationContext(chunkGenerator, heightAccessor));
        BlockPos basePos = new BlockPos(chunkPos.m_45604_(), y, chunkPos.m_45605_());
        int baseX = basePos.m_123341_();
        int baseZ = basePos.m_123343_();
        int minHeight = Integer.MAX_VALUE;
        int maxHeight = Integer.MIN_VALUE;
        int airBlockSteps = 0;
        int fluidBlockSteps = 0;
        for (int xOffset = -flatnessCheckDistance; xOffset <= flatnessCheckDistance; xOffset += offsetStep) {
            for (int zOffset = -flatnessCheckDistance; zOffset <= flatnessCheckDistance; zOffset += offsetStep) {
                int x = baseX + xOffset;
                int z = baseZ + zOffset;
                int height = chunkGenerator.m_223235_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor, randomState);
                if (height > maxHeight && (maxHeight = height) - minHeight > flatnessCheckThreshold) {
                    return false;
                }
                if (height < minHeight && maxHeight - (minHeight = height) > flatnessCheckThreshold) {
                    return false;
                }
                if (areAirBlocksAllowed && areLiquidBlocksAllowed) continue;
                BlockState blockState = null;
                if (!areAirBlocksAllowed) {
                    if (blockState == null) {
                        blockState = chunkGenerator.m_214184_(x, z, heightAccessor, randomState).m_183556_(height);
                    }
                    if (blockState.m_60795_() && ++airBlockSteps >= allowedAirBlockSteps) {
                        return false;
                    }
                }
                if (areLiquidBlocksAllowed) continue;
                if (blockState == null) {
                    blockState = chunkGenerator.m_214184_(x, z, heightAccessor, randomState).m_183556_(height);
                }
                if (blockState.m_60819_().m_76178_() || ++fluidBlockSteps < allowedLiquidBlockSteps) continue;
                return false;
            }
        }
        return true;
    }
}

