/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.datagen.provider;

import net.Pandarix.betterarcheology.block.ModBlocks;
import net.Pandarix.betterarcheology.item.ModItems;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "betterarcheology", existingFileHelper);
    }

    protected void registerModels() {
        ModBlocks.BLOCKS.getEntries().stream().filter(block -> block != ModBlocks.RADIANCE_TOTEM && ModItems.isFossil((Block)block.get())).forEach(fossil -> this.prefixedBlockParent((RegistryObject<Block>)fossil, "fossils"));
        this.basicItem(ModItems.ARTIFACT_SHARDS.getId());
        this.basicItem(ModBlocks.GROWTH_TOTEM.getId());
        this.basicItem(ModBlocks.RADIANCE_TOTEM.getId());
        this.basicItem(ModItems.TORRENT_TOTEM.getId());
        this.basicItem(ModItems.UNIDENTIFIED_ARTIFACT.getId());
        this.basicItem(ModBlocks.ROTTEN_DOOR.getId());
        this.brushParent(ModItems.IRON_BRUSH);
        this.brushParent(ModItems.DIAMOND_BRUSH);
        this.brushParent(ModItems.NETHERITE_BRUSH);
        this.simpleBlockParent(ModBlocks.ARCHEOLOGY_TABLE);
        this.simpleBlockParent(ModBlocks.CHISELED_BONE_BLOCK);
        this.simpleBlockParent(ModBlocks.CRACKED_MUD_BRICKS);
        this.simpleBlockParent(ModBlocks.INFESTED_MUD_BRICKS);
        this.simpleBlockParent(ModBlocks.CRACKED_MUD_BRICK_SLAB);
        this.simpleBlockParent(ModBlocks.CRACKED_MUD_BRICK_STAIRS);
        this.simpleBlockParent(ModBlocks.EVOKER_TRAP);
        this.simpleBlockParent(ModBlocks.ROTTEN_LOG);
        this.simpleBlockParent(ModBlocks.ROTTEN_PLANKS);
        this.prefixedBlockParent(ModBlocks.ROTTEN_PRESSURE_PLATE, "rotten_wood");
        this.simpleBlockParent(ModBlocks.ROTTEN_SLAB);
        this.simpleBlockParent(ModBlocks.ROTTEN_STAIRS);
        this.prefixedBlockParent(ModBlocks.FOSSILIFEROUS_DIRT, "fossiliferous");
        this.prefixedBlockParent(ModBlocks.ROTTEN_FENCE_GATE, "rotten_wood");
        this.prefixedBlockParent(ModBlocks.SUSPICIOUS_DIRT, "suspicious");
        this.prefixedBlockParent(ModBlocks.SUSPICIOUS_RED_SAND, "suspicious");
        ((ItemModelBuilder)this.withExistingParent(ModItems.SOUL_TOTEM.getId().m_135815_(), this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + ModItems.SOUL_TOTEM.getId().m_135815_()));
        this.withExistingParent(ModBlocks.LOOT_VASE.getId().m_135815_(), this.modLoc("block/loot_vase_0"));
        this.withExistingParent(ModBlocks.VASE.getId().m_135815_(), this.modLoc("block/loot_vase_0"));
        this.withExistingParent(ModBlocks.LOOT_VASE_CREEPER.getId().m_135815_(), this.modLoc("block/loot_vase_3"));
        this.withExistingParent(ModBlocks.VASE_CREEPER.getId().m_135815_(), this.modLoc("block/loot_vase_3"));
        this.withExistingParent(ModBlocks.LOOT_VASE_GREEN.getId().m_135815_(), this.modLoc("block/loot_vase_6"));
        this.withExistingParent(ModBlocks.VASE_GREEN.getId().m_135815_(), this.modLoc("block/loot_vase_6"));
        this.withExistingParent(ModBlocks.ROTTEN_FENCE.getId().m_135815_(), this.modLoc("block/rotten_wood/rotten_fence_inventory"));
        this.withExistingParent(ModBlocks.ROTTEN_TRAPDOOR.getId().m_135815_(), this.modLoc("block/rotten_wood/rotten_trapdoor_bottom"));
    }

    private ItemModelBuilder simpleBlockParent(RegistryObject<Block> block) {
        return this.prefixedBlockParent(block, "");
    }

    private ItemModelBuilder prefixedBlockParent(RegistryObject<Block> block, String prefix) {
        return (ItemModelBuilder)this.withExistingParent(block.getId().m_135815_(), this.modLoc("block/" + (String)(prefix.isBlank() ? "" : prefix + "/") + block.getId().m_135815_() + (ModItemModelProvider.hasMultipleVariants(prefix) ? "_0" : "")));
    }

    private ItemModelBuilder brushParent(RegistryObject<Item> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().m_135815_(), this.mcLoc("item/brush"))).texture("layer0", this.modLoc("item/brushes/" + item.getId().m_135815_()));
    }

    private static boolean hasMultipleVariants(String path) {
        return path.equals("fossils") || path.equals("fossiliferous") || path.equals("suspicious");
    }
}

