/*
 * Decompiled with CFR 0.152.
 */
package net.Pandarix.betterarcheology.block.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.Pandarix.betterarcheology.block.custom.FossilBaseBlock;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class CreeperFossilBlock
extends FossilBaseBlock {
    private static final Map<Direction, VoxelShape> CREEPER_SHAPES_FOR_DIRECTION = ImmutableMap.of((Object)Direction.NORTH, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.5, (double)5.25, (double)5.5, (double)12.5, (double)17.25, (double)10.5), Block.m_49796_((double)3.0, (double)0.0, (double)9.5, (double)13.0, (double)6.5, (double)14.5), Block.m_49796_((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)6.5, (double)6.5)}), (Object)Direction.SOUTH, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)3.5, (double)5.25, (double)5.5, (double)12.5, (double)17.25, (double)10.5), Block.m_49796_((double)3.0, (double)0.0, (double)9.5, (double)13.0, (double)6.5, (double)14.5), Block.m_49796_((double)3.0, (double)0.0, (double)1.5, (double)13.0, (double)6.5, (double)6.5)}), (Object)Direction.WEST, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.5, (double)5.25, (double)3.5, (double)10.5, (double)17.25, (double)12.5), Block.m_49796_((double)1.5, (double)0.0, (double)3.0, (double)6.5, (double)6.5, (double)13.0), Block.m_49796_((double)9.5, (double)0.0, (double)3.0, (double)14.5, (double)6.5, (double)13.0)}), (Object)Direction.EAST, (Object)Shapes.m_83124_((VoxelShape)Block.m_49796_((double)3.5, (double)17.25, (double)3.5, (double)12.5, (double)26.25, (double)12.5), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)5.5, (double)5.25, (double)3.5, (double)10.5, (double)17.25, (double)12.5), Block.m_49796_((double)1.5, (double)0.0, (double)3.0, (double)6.5, (double)6.5, (double)13.0), Block.m_49796_((double)9.5, (double)0.0, (double)3.0, (double)14.5, (double)6.5, (double)13.0)}));

    public CreeperFossilBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void m_214162_(BlockState blockState, Level level, BlockPos pos, RandomSource random) {
        super.m_214162_(blockState, level, pos, random);
        SimpleParticleType particle = random.m_188499_() ? ParticleTypes.f_175834_ : ParticleTypes.f_123762_;
        Vec3 center = pos.m_252807_();
        if (level.m_5776_()) {
            level.m_7106_((ParticleOptions)particle, center.m_7096_() + (double)(random.m_188501_() * (float)CreeperFossilBlock.getRandomSign(random)), center.m_7098_() + (double)(random.m_188501_() * (float)CreeperFossilBlock.getRandomSign(random)), center.m_7094_() + (double)(random.m_188501_() * (float)CreeperFossilBlock.getRandomSign(random)), (double)(random.m_188501_() / 50.0f * (float)CreeperFossilBlock.getRandomSign(random)), (double)(random.m_188501_() / 30.0f), (double)(random.m_188501_() / 50.0f * (float)CreeperFossilBlock.getRandomSign(random)));
        }
    }

    private static int getRandomSign(RandomSource rand) {
        return rand.m_188499_() ? 1 : -1;
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return CREEPER_SHAPES_FOR_DIRECTION.get(blockState.m_61143_((Property)FACING));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(ItemStack stack, BlockGetter getter, List<Component> component, TooltipFlag flag) {
        component.add((Component)Component.m_237115_((String)"block.betterarcheology.creeper_fossil_tooltip").m_130940_(ChatFormatting.GRAY));
        super.m_5871_(stack, getter, component, flag);
    }
}

