/*
 * Decompiled with CFR 0.152.
 */
package com.github.spacemex.skillsexpnotifier.client;

import com.github.spacemex.skillsexpnotifier.Skillsexpnotifier;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.File;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;

@OnlyIn(value=Dist.CLIENT)
public class SearchForSkills {
    private static final Path GAME_DIR = FMLPaths.GAMEDIR.get();
    private static final Path KUBEJS_DIR = GAME_DIR.resolve("kubejs");
    private static final Path KUBE_DATA_DIR = KUBEJS_DIR.resolve("data");
    private static final Path DATAPACK_DIR = GAME_DIR.resolve("datapacks");

    public static List<CategoryData> scan() {
        ArrayList<File> found = new ArrayList<File>();
        SearchForSkills.scanDir(DATAPACK_DIR, found);
        if (ModList.get().isLoaded("kubejs")) {
            SearchForSkills.scanDir(KUBE_DATA_DIR, found);
        }
        ArrayList<CategoryData> results = new ArrayList<CategoryData>();
        for (File file : found) {
            try {
                BufferedReader r = Files.newBufferedReader(file.toPath());
                try {
                    JsonObject obj = JsonParser.parseReader((Reader)r).getAsJsonObject();
                    String idPath = file.getParentFile().getName();
                    String itemId = obj.getAsJsonObject("icon").getAsJsonObject("data").get("item").getAsString();
                    results.add(new CategoryData(idPath, itemId));
                }
                finally {
                    if (r == null) continue;
                    ((Reader)r).close();
                }
            }
            catch (Exception e) {
                Skillsexpnotifier.LOGGER.warn("Failed to parse {}", (Object)file.getPath(), (Object)e);
            }
        }
        return results;
    }

    private static void scanDir(Path dir, List<File> out) {
        File d = dir.toFile();
        if (!d.exists() || !d.isDirectory()) {
            return;
        }
        for (File f : Objects.requireNonNull(d.listFiles())) {
            if (f.isDirectory()) {
                SearchForSkills.scanDir(f.toPath(), out);
                continue;
            }
            if (!"category.json".equals(f.getName())) continue;
            out.add(f);
        }
    }

    public record CategoryData(String idPath, String iconId) {
    }
}

