/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.placementcondition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.worldgen.placementcondition.PlacementCondition;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.InclusiveRange;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.level.levelgen.Heightmap;

public record HeightFilterPlacementCondition(RangeType rangeType, Optional<Heightmap.Types> heightmap, InclusiveRange<Integer> permittedRange) implements PlacementCondition
{
    public static final MapCodec<HeightFilterPlacementCondition> CODEC = ExtraCodecs.m_285994_((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)RangeType.CODEC.fieldOf("range_type").forGetter(HeightFilterPlacementCondition::rangeType), (App)Heightmap.Types.f_64274_.optionalFieldOf("heightmap").forGetter(HeightFilterPlacementCondition::heightmap), (App)InclusiveRange.f_184562_.fieldOf("permitted_range").forGetter(HeightFilterPlacementCondition::permittedRange)).apply((Applicative)instance, HeightFilterPlacementCondition::new)), HeightFilterPlacementCondition::validate);

    private DataResult<HeightFilterPlacementCondition> validate() {
        if (this.rangeType == RangeType.HEIGHTMAP_RELATIVE && this.heightmap.isEmpty()) {
            return DataResult.error(() -> "Heightmap relative range type must be used with a heightmap");
        }
        return DataResult.success((Object)this);
    }

    @Override
    public boolean test(PlacementCondition.Context context, BlockPos pos) {
        if (this.heightmap.isEmpty()) {
            return this.permittedRange.m_184578_((Comparable)Integer.valueOf(pos.m_123342_()));
        }
        int heightmapY = context.generator().m_223221_(pos.m_123341_(), pos.m_123343_(), this.heightmap.get(), context.heightAccessor(), context.randomState());
        int y = this.rangeType == RangeType.ABSOLUTE ? heightmapY : pos.m_123342_() - heightmapY;
        return this.permittedRange.m_184578_((Comparable)Integer.valueOf(y));
    }

    @Override
    public MapCodec<? extends PlacementCondition> codec() {
        return CODEC;
    }

    public static enum RangeType implements StringRepresentable
    {
        ABSOLUTE("absolute"),
        HEIGHTMAP_RELATIVE("heightmap_relative");

        public static final Codec<RangeType> CODEC;
        private final String name;

        private RangeType(String name) {
            this.name = name;
        }

        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(RangeType::values);
        }
    }
}

