/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.SinglePoolElementAccessor;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.predicate.ModifierPredicate;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public record SetPoolElementProcessorsModifier(ModifierPredicate predicate, HolderSet<StructureTemplatePool> templatePools, Optional<List<ResourceLocation>> locations, Holder<StructureProcessorList> processorList, boolean append) implements Modifier
{
    public static final Codec<SetPoolElementProcessorsModifier> CODEC = RecordCodecBuilder.create(instance -> Modifier.addModifierFields(instance).and(instance.group((App)LithostitchedCodecs.registrySet(Registries.f_256948_, "template_pool").forGetter(SetPoolElementProcessorsModifier::templatePools), (App)LithostitchedCodecs.singleOrList(ResourceLocation.f_135803_).optionalFieldOf("locations").forGetter(SetPoolElementProcessorsModifier::locations), (App)StructureProcessorType.f_74468_.fieldOf("processor_list").forGetter(SetPoolElementProcessorsModifier::processorList), (App)Codec.BOOL.fieldOf("append").orElse((Object)true).forGetter(SetPoolElementProcessorsModifier::append))).apply((Applicative)instance, SetPoolElementProcessorsModifier::new));

    @Override
    public ModifierPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void applyModifier() {
        for (Holder templatePool : this.templatePools) {
            StructureTemplatePoolAccessor pool = (StructureTemplatePoolAccessor)templatePool.m_203334_();
            for (StructurePoolElement element : pool.getRawTemplates().stream().map(Pair::getFirst).toList()) {
                this.applyModifier(element);
            }
        }
    }

    private void applyModifier(StructurePoolElement element) {
        if (element instanceof SinglePoolElement) {
            SinglePoolElementAccessor accessor = (SinglePoolElementAccessor)element;
            Optional template = accessor.getTemplate().left();
            if (this.locations.isEmpty() || template.isPresent() && this.locations.get().contains(template.get())) {
                this.addProcessor(accessor);
            }
        } else if (element instanceof DelegatingPoolElement) {
            DelegatingPoolElement exclusive = (DelegatingPoolElement)element;
            this.applyModifier(exclusive.delegate());
        }
    }

    private void addProcessor(SinglePoolElementAccessor element) {
        ArrayList processors = new ArrayList();
        if (this.append) {
            processors.addAll(((StructureProcessorList)element.getProcessors().m_203334_()).m_74425_());
        }
        processors.addAll(((StructureProcessorList)this.processorList.m_203334_()).m_74425_());
        element.setProcessors((Holder<StructureProcessorList>)Holder.m_205709_((Object)new StructureProcessorList(processors)));
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return this.append ? Modifier.ModifierPhase.REPLACE : Modifier.ModifierPhase.ADD;
    }

    @Override
    public Codec<? extends Modifier> codec() {
        return CODEC;
    }
}

