/*
 * Decompiled with CFR 0.152.
 */
package thetadev.constructionwand.items.wand;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import thetadev.constructionwand.ConstructionWand;
import thetadev.constructionwand.api.IWandCore;
import thetadev.constructionwand.basics.WandUtil;
import thetadev.constructionwand.basics.option.IOption;
import thetadev.constructionwand.basics.option.WandOptions;
import thetadev.constructionwand.data.ICustomItemModel;
import thetadev.constructionwand.data.ItemModelGenerator;
import thetadev.constructionwand.wand.WandJob;

public abstract class ItemWand
extends Item
implements ICustomItemModel {
    public ItemWand(Item.Properties properties) {
        super(properties);
    }

    @Nonnull
    public InteractionResult m_6225_(UseOnContext context) {
        Player player = context.m_43723_();
        InteractionHand hand = context.m_43724_();
        Level world = context.m_43725_();
        if (world.f_46443_ || player == null) {
            return InteractionResult.FAIL;
        }
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6047_() && ConstructionWand.instance.undoHistory.isUndoActive(player)) {
            return ConstructionWand.instance.undoHistory.undo(player, world, context.m_8083_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
        }
        WandJob job = ItemWand.getWandJob(player, world, new BlockHitResult(context.m_43720_(), context.m_43719_(), context.m_8083_(), false), stack);
        return job.doIt() ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (!player.m_6047_()) {
            if (world.f_46443_) {
                return InteractionResultHolder.m_19100_((Object)stack);
            }
            WandJob job = ItemWand.getWandJob(player, world, BlockHitResult.m_82426_((Vec3)player.m_20154_(), (Direction)WandUtil.fromVector(player.m_20154_()), (BlockPos)player.m_20183_()), stack);
            return job.doIt() ? InteractionResultHolder.m_19090_((Object)stack) : InteractionResultHolder.m_19100_((Object)stack);
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public static WandJob getWandJob(Player player, Level world, @Nullable BlockHitResult rayTraceResult, ItemStack wand) {
        WandJob wandJob = new WandJob(player, world, rayTraceResult, wand);
        wandJob.getSnapshots();
        return wandJob;
    }

    public boolean m_8096_(@Nonnull BlockState blockIn) {
        return false;
    }

    public boolean m_6832_(@Nonnull ItemStack toRepair, @Nonnull ItemStack repair) {
        return false;
    }

    public int remainingDurability(ItemStack stack) {
        return Integer.MAX_VALUE;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(@Nonnull ItemStack itemstack, Level worldIn, @Nonnull List<Component> lines, @Nonnull TooltipFlag extraInfo) {
        WandOptions options = new WandOptions(itemstack);
        int limit = ((IWandCore)options.cores.get()).getWandAction().getLimit(itemstack);
        String langTooltip = "constructionwand.tooltip.";
        if (Screen.m_96638_()) {
            for (int i = 1; i < options.allOptions.length; ++i) {
                IOption<?> opt = options.allOptions[i];
                lines.add((Component)Component.m_237115_((String)opt.getKeyTranslation()).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237115_((String)opt.getValueTranslation()).m_130940_(ChatFormatting.GRAY)));
            }
            if (!options.cores.getUpgrades().isEmpty()) {
                lines.add((Component)Component.m_237113_((String)""));
                lines.add((Component)Component.m_237115_((String)(langTooltip + "cores")).m_130940_(ChatFormatting.GRAY));
                for (IWandCore core : options.cores.getUpgrades()) {
                    lines.add((Component)Component.m_237115_((String)(options.cores.getKeyTranslation() + "." + core.getRegistryName().toString())));
                }
            }
        } else {
            IOption<?> opt = options.allOptions[0];
            lines.add((Component)Component.m_237110_((String)(langTooltip + "blocks"), (Object[])new Object[]{limit}).m_130940_(ChatFormatting.GRAY));
            lines.add((Component)Component.m_237115_((String)opt.getKeyTranslation()).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237115_((String)opt.getValueTranslation()).m_130940_(ChatFormatting.WHITE)));
            lines.add((Component)Component.m_237115_((String)(langTooltip + "shift")).m_130940_(ChatFormatting.AQUA));
        }
    }

    public static void optionMessage(Player player, IOption<?> option) {
        player.m_5661_((Component)Component.m_237115_((String)option.getKeyTranslation()).m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237115_((String)option.getValueTranslation()).m_130940_(ChatFormatting.WHITE)).m_7220_((Component)Component.m_237113_((String)" - ").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)option.getDescTranslation()).m_130940_(ChatFormatting.WHITE)), true);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator, String name) {
        ModelBuilder wandWithCore = ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(name + "_core", "item/handheld")).texture("layer0", generator.modLoc("item/" + name))).texture("layer1", generator.modLoc("item/overlay_core"));
        ((ItemModelBuilder)((ItemModelBuilder)generator.withExistingParent(name, "item/handheld")).texture("layer0", generator.modLoc("item/" + name))).override().predicate(generator.modLoc("using_core"), 1.0f).model((ModelFile)wandWithCore).end();
    }
}

