/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.util;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public class SimpleMapContentRegistry<V extends Identifiable> {
    private final Map<ResourceLocation, V> entries = new Object2ObjectOpenHashMap();
    private final List<ResourceLocation> orderedKeys = new ArrayList<ResourceLocation>();

    public V register(V entry) {
        this.entries.put(entry.getId(), entry);
        this.orderedKeys.add(entry.getId());
        return entry;
    }

    public V get(ResourceLocation name) {
        return (V)((Identifiable)this.entries.get(name));
    }

    public V getOrDefault(ResourceLocation name) {
        if (this.orderedKeys.size() <= 0) {
            throw new IllegalStateException("Tried to get from empty registry!");
        }
        return (V)this.entries.getOrDefault(name, (Identifiable)this.entries.get(this.orderedKeys.get(0)));
    }

    public void forEach(Consumer<V> action) {
        this.orderedKeys.forEach((? super T k) -> action.accept((Identifiable)this.entries.get(k)));
    }

    public static interface Identifiable {
        public ResourceLocation getId();
    }
}

