/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocators.part;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.math.MathHelper;
import codechicken.multipart.api.MultipartType;
import codechicken.multipart.api.part.MultiPart;
import codechicken.translocators.init.TranslocatorsModContent;
import codechicken.translocators.part.TranslocatorPart;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidTranslocatorPart
extends TranslocatorPart {
    public List<MovingLiquid> movingLiquids = new LinkedList<MovingLiquid>();
    public List<MovingLiquid> exitingLiquids = new LinkedList<MovingLiquid>();

    @Override
    public ItemStack getItem() {
        return new ItemStack((ItemLike)TranslocatorsModContent.fluidTranslocatorItem.get(), 1);
    }

    @Override
    public int getTType() {
        return 1;
    }

    public MultipartType<?> getType() {
        return (MultipartType)TranslocatorsModContent.fluidTranslocatorPartType.get();
    }

    @Override
    public boolean canStay() {
        return this.capCache().getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.f_122348_[this.side]).isPresent();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().m_5776_()) {
            Iterator<MovingLiquid> iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = iterator.next();
                if (!m.update()) continue;
                iterator.remove();
                this.exitingLiquids.add(m);
            }
            this.exitingLiquids.removeIf(MovingLiquid::update);
        } else if (this.a_eject) {
            IFluidHandler[] attached = new IFluidHandler[6];
            for (int i = 0; i < 6; ++i) {
                attached[i] = this.canInsert(i) || i == this.side ? (IFluidHandler)this.capCache().getCapabilityOr(ForgeCapabilities.FLUID_HANDLER, Direction.f_122348_[i], (Object)EmptyFluidHandler.INSTANCE) : EmptyFluidHandler.INSTANCE;
            }
            IFluidHandler myHandler = attached[this.side];
            FluidStack drain = myHandler.drain(this.fast ? 1000 : 100, IFluidHandler.FluidAction.SIMULATE);
            if (drain != null && drain.getAmount() != 0) {
                ArrayList<FluidTransfer> transfers = new ArrayList<FluidTransfer>();
                FluidStack move = drain.copy();
                this.spreadOutput(move, this.getOutputs(), attached, transfers);
                myHandler.drain(drain.getAmount() - move.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.sendTransferPacket(transfers);
            }
        }
    }

    private void spreadOutput(FluidStack move, int[] outputs, IFluidHandler[] attached, List<FluidTransfer> transfers) {
        for (int k = 0; k < outputs.length && move.getAmount() > 0; ++k) {
            int dst = outputs[k];
            IFluidHandler outaccess = attached[dst];
            int fit = outaccess.fill(move, IFluidHandler.FluidAction.SIMULATE);
            int spread = outputs.length - k;
            if ((fit = Math.min(fit, move.getAmount() / spread + this.level().f_46441_.m_188503_(move.getAmount() % spread + 1))) == 0) continue;
            FluidStack add = new FluidStack(move, fit);
            outaccess.fill(add, IFluidHandler.FluidAction.EXECUTE);
            move.shrink(fit);
            transfers.add(new FluidTransfer(dst, add));
        }
    }

    public int[] getOutputs() {
        int[] att = new int[6];
        int[] r_att = new int[6];
        int a = 0;
        int r_a = 0;
        for (byte i = 0; i < 6; ++i) {
            FluidTranslocatorPart part;
            MultiPart p = this.tile().getSlottedPart((int)i);
            if (!(p instanceof FluidTranslocatorPart) || (part = (FluidTranslocatorPart)p).canEject() || i == this.side) continue;
            if (part.redstone) {
                r_att[r_a++] = i;
                continue;
            }
            att[a++] = i;
        }
        int[] ret = new int[a + r_a];
        if (a > 0) {
            System.arraycopy(att, 0, ret, 0, a);
        }
        if (r_a > 0) {
            System.arraycopy(r_att, 0, ret, a, r_a);
        }
        return ret;
    }

    private void sendTransferPacket(List<FluidTransfer> transfers) {
        if (transfers.isEmpty()) {
            return;
        }
        this.sendIncUpdate(packet -> {
            packet.writeByte(transfers.size());
            for (FluidTransfer t : transfers) {
                packet.writeByte(t.dst);
                packet.writeFluidStack(t.fluid);
            }
        });
    }

    public List<MovingLiquid> getMovingLiquids() {
        LinkedList<MovingLiquid> liquids = new LinkedList<MovingLiquid>();
        liquids.addAll(this.movingLiquids);
        liquids.addAll(this.exitingLiquids);
        return liquids;
    }

    @Override
    public void readIncUpdate(MCDataInput packet) {
        ArrayList<FluidTransfer> transfers = new ArrayList<FluidTransfer>();
        HashSet<Integer> updatedDests = new HashSet<Integer>();
        int num_t = packet.readUByte();
        for (int i = 0; i < num_t; ++i) {
            short dst = packet.readUByte();
            FluidStack fluid = packet.readFluidStack();
            transfers.add(new FluidTransfer(dst, fluid));
            updatedDests.add(Integer.valueOf(dst));
        }
        for (FluidTransfer t : transfers) {
            boolean found = false;
            Iterator<MovingLiquid> iterator = this.movingLiquids.iterator();
            while (iterator.hasNext()) {
                MovingLiquid m = iterator.next();
                if (m.liquid.isFluidEqual(t.fluid) && m.dst == t.dst) {
                    m.addLiquid(t.fluid.getAmount());
                    found = true;
                    continue;
                }
                if (m.dst != t.dst || updatedDests.contains(m.dst)) continue;
                iterator.remove();
                m.finish();
                this.exitingLiquids.add(m);
            }
            if (found) continue;
            this.movingLiquids.add(new MovingLiquid(t.dst, t.fluid));
        }
    }

    public class MovingLiquid {
        public int dst;
        public FluidStack liquid;
        public double a_start;
        public double b_start;
        public double a_end;
        public double b_end;
        public boolean fast;

        public MovingLiquid(int dst, FluidStack add) {
            this.dst = dst;
            this.liquid = add;
            this.fast = FluidTranslocatorPart.this.fast;
            this.capLiquid();
        }

        private void capLiquid() {
            this.liquid.setAmount(Math.min(this.liquid.getAmount(), this.fast ? 1000 : 100));
        }

        public boolean update() {
            if (this.a_end == 1.0) {
                return true;
            }
            this.b_start = this.a_start;
            this.a_start = MathHelper.approachLinear((double)this.a_start, (double)1.0, (double)0.2);
            this.b_end = this.a_end;
            if (this.liquid.getAmount() > 0) {
                this.liquid.setAmount(Math.max(this.liquid.getAmount() - (this.fast ? 200 : 20), 0));
                return this.liquid.getAmount() == 0;
            }
            this.a_end = MathHelper.approachLinear((double)this.a_end, (double)1.0, (double)0.2);
            return false;
        }

        public void addLiquid(int moving) {
            if (this.liquid.getAmount() == 0) {
                throw new IllegalArgumentException("Something went wrong!");
            }
            this.liquid.grow(moving);
            this.fast = FluidTranslocatorPart.this.fast;
            this.capLiquid();
        }

        public void finish() {
            this.liquid.setAmount(0);
        }
    }

    private class FluidTransfer {
        int dst;
        FluidStack fluid;

        public FluidTransfer(int dst, FluidStack fluid) {
            this.dst = dst;
            this.fluid = fluid;
        }
    }
}

